#include "g_local.h"



// radar consts & macros
#define	SCANNER_UNIT                   32
#define	SCANNER_RANGE                  100

#define	PIC_OVERLAY                    "o"

#define	PIC_DOT                        "a"
#define	PIC_DOWN                       "b"
#define	PIC_UP                         "c"

#define	PIC_EDOT                       "e"
#define	PIC_EDOWN                      "f"
#define	PIC_EUP                        "g"

#define	PIC_MEDOT                      "m"

#define	PIC_TRACK                      "h"
#define	PIC_TRACKDOWN                  "i"
#define	PIC_TRACKUP                    "j"



/*
// void spawn_radar(void)
called from g_spawn.c inside void SP_worldspawn (edict_t *ent)
*/
void spawn_radar(void)  // speedway v1.3
{
	gi.imageindex (PIC_OVERLAY);
	gi.imageindex (PIC_UP);
	gi.imageindex (PIC_DOWN);
	gi.imageindex (PIC_DOT);
	gi.imageindex (PIC_EUP);
	gi.imageindex (PIC_EDOWN);
	gi.imageindex (PIC_EDOT);
	gi.imageindex (PIC_MEDOT);
	gi.imageindex (PIC_TRACKUP);
	gi.imageindex (PIC_TRACKDOWN);
	gi.imageindex (PIC_TRACK);
}


/*
// void Cmd_Radar_f (edict_t *ent)
called from hexed.c inside qboolean SpeedwayCommands (edict_t *ent)
*/
void Cmd_Radar_f (edict_t *ent)  // speedway v1.3
{   
	if (!ent->client 
		|| ent->health <= 0 
		|| ent->client->pers.spectator != PLAYING
		|| ent->svflags & SVF_NOCLIENT 
		|| ( (level.modeset != MATCH) && (level.modeset != TEAMPLAY) )
		) return;

	if (ent->client->last_wave > (level.time - 1) && (ent->client->last_wave <= level.time))
    return;
	ent->client->last_wave = level.time; // speedway 1.4 anti spam

	// toggle low on/off bit (and clear scores/inventory display if required)
	if ((ent->client->resp.radar_active ^= 1) & 1)
	{
		ent->client->showinventory	= 0;
		ent->client->showscores = RADAR;
		gi.cprintf(ent,PRINT_HIGH,"%s: radar \"ON\"\n", ent->client->pers.netname);
		// set "just changed" bit
		//	ent->client->resp.radar_active |= 2;
	}
	else
	{
		gi.cprintf(ent,PRINT_HIGH,"%s: radar \"OFF\"\n", ent->client->pers.netname);
		ent->client->showinventory	= 0;
		ent->client->showscores = 0;
	}
}



/*
// void Show_Radar (edict_t *ent)
called from p_hud.c inside void DeathmatchScoreboard (edict_t *ent)
*/
#define	SAFE_STRCAT(org,add,maxlen) if((strlen(org)+strlen(add)) < maxlen) strcat(org,add);



#define SHOWTRACK { VectorSubtract (ent->s.origin, track->s.origin, v); \
		hd = v[2] / SCANNER_UNIT;	v[2] = 0;	len = VectorLength (v) / SCANNER_UNIT; \
		if (len <= SCANNER_RANGE) {   int	sx,	sy;	vec3_t	dp;	vec3_t	normal = {0,0,-1}; \
			VectorNormalize(v);	RotatePointAroundVector( dp, normal, v, ent->s.angles[1]); \
			VectorScale(dp,len*80/SCANNER_RANGE,dp); sx = (160 + dp[1]) - 2 - xoffset; \
			sy = (120 + dp[0]) - 2 + yoffset; \
			if (hd > 0) tag = PIC_TRACKDOWN; \
			else if (hd < 0) tag = PIC_TRACKUP; \
			else tag = PIC_TRACK; \
			Com_sprintf (entry, sizeof(entry),"xv %i yv %i picn %s ", sx, sy, tag); \
			SAFE_STRCAT(string,entry,500) /*ADDTHESTRING*/ } }



void Show_Radar (edict_t *ent)  // speedway v1.3
{
	char	entry[1024];
	char	string[1400];
	int		stringlength=0;
	int     xoffset;
	int     yoffset;
	int		i,xpos,ypos,rezolution,j=0;
	edict_t	*player = g_edicts;
	char    *tag, *rez;
	float	len;
	int		hd;
	vec3_t	v;
	edict_t	*track = NULL;

	string[0] = 0;

	// client is spectating
	if (   (ent->svflags & SVF_NOCLIENT) 
		|| (ent->client->pers.spectator != PLAYING) 
		|| (ent->deadflag == DEAD_DEAD)
	   )
	{
		ent->client->showscores = 0;
		return;
	}


	rez = Info_ValueForKey (ent->client->pers.userinfo, "gl_mode");

		 if (!Q_stricmp (rez, "1")) rezolution = 1;
	else if (!Q_stricmp (rez, "6")) rezolution = 6;
	else if (!Q_stricmp (rez, "5")) rezolution = 5;
	else if (!Q_stricmp (rez, "4")) rezolution = 4;
	else if (!Q_stricmp (rez, "3")) rezolution = 3;
	else if (!Q_stricmp (rez, "2")) rezolution = 2;
	else/*if(!Q_stricmp (rez,"0"))*/rezolution = 0;

	switch(rezolution)
	{
	case 0:		xoffset = 110; yoffset = 160; break;
	default:
	case 1:		xoffset = 150; yoffset = 215; break;
	case 2:     xoffset = 170; yoffset = 265; break;
	case 3:     xoffset = 180; yoffset = 295; break;
	case 4:		xoffset = 200; yoffset = 340; break;
	case 5:     xoffset = 250; yoffset = 390; break;
	case 6:     xoffset = 300; yoffset = 500; break;
	}



	xpos = 80 - xoffset;
	ypos = 40 + yoffset;

	
	Com_sprintf (entry, sizeof(entry),"xv %i yv %i picn %s ", xpos, ypos, PIC_OVERLAY);
	ADDTHESTRING


	// Players dots
	for (i=0 ; i < game.maxclients ; i++)
	{
		// move to player edict
		player++;

		// in use 
		if (!player->inuse
		|| !player->client
		|| player->deadflag)
			continue;

		// Don't show ghosts either.
		if (player->movetype == MOVETYPE_NOCLIP && player->solid == SOLID_NOT) continue;

		// calc player to enemy vector
		VectorSubtract (ent->s.origin, player->s.origin, v);

		// save height differential
		hd = v[2] / SCANNER_UNIT;

		// remove height component
		v[2] = 0;

		// calc length of distance from top down view (no z)
		len = VectorLength (v) / SCANNER_UNIT;

		// in range ?
		if (len <= SCANNER_RANGE)
		{
			int		sx,
					sy;

			vec3_t	dp;

			vec3_t	normal = {0,0,-1};


			// normal vector to enemy
			VectorNormalize(v);

			// rotate round player view angle (yaw)
			RotatePointAroundVector( dp, normal, v, ent->s.angles[1]);

			// scale to fit scanner range (80 = pixel range of scanner)
			VectorScale(dp,len*80/SCANNER_RANGE,dp);

			// calc screen (x,y) (2 = half dot width)
			sx = (160 + dp[1]) - 2 - xoffset;
			sy = (120 + dp[0]) - 2 + yoffset;

			// setup dot graphic
			//tag = PIC_DOT;


			if(player == ent) tag = PIC_MEDOT;
			else if (hd > 0)
				if(player->client->pers.team && player->client->pers.team != ent->client->pers.team) tag = PIC_EDOWN;
				else tag = PIC_DOWN;

			else if (hd < 0)
				if(player->client->pers.team && player->client->pers.team != ent->client->pers.team) tag = PIC_EUP;
				else tag = PIC_UP;

			else if(player->client->pers.team != ent->client->pers.team) tag = PIC_EDOT;
			else tag = PIC_DOT;

			Com_sprintf (entry, sizeof(entry),"xv %i yv %i picn %s ", sx, sy, tag);
			ADDTHESTRING
		}
	}


	if(level.killed_monsters) // path_corners speedway v1.4
	{
		while((track = G_Find (track, FOFS(classname), "path_corner")) != NULL)	
		{
			if (VectorDistance( track->s.origin, ent->s.origin ) > 1024) continue;
			if(track->style == TRACKSTYLE)	SHOWTRACK
		}
	}
	else if(level.total_monsters) // info_nulls speedway v1.4
	{
		while((track = G_Find (track, FOFS(classname), "info_null")) != NULL)	
		{
			if (VectorDistance( track->s.origin, ent->s.origin ) > 1024) continue;
			if(track->style == TRACKSTYLE)	SHOWTRACK
		}
	}


	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}