
#include "g_local.h"
#include "m_player.h"



static	edict_t		*current_player;
static	gclient_t	*current_client;

static	vec3_t	forward, right, up;
float	xyspeed;

float	bobmove;
int		bobcycle;		// odd cycles are right foot going forward
float	bobfracsin;		// sin(bobfrac*M_PI)

/*
===============
SV_CalcRoll

===============
*/
float SV_CalcRoll (vec3_t angles, vec3_t velocity)
{
	float	sign;
	float	side;
	float	value;
	
	side = DotProduct (velocity, right);
	sign = side < 0 ? -1 : 1;
	side = fabs(side);
	
	value = sv_rollangle->value;

	if (side < sv_rollspeed->value)
		side = side * value / sv_rollspeed->value;
	else
		side = value;
	
	return side*sign;
	
}


/*
===============
P_DamageFeedback

Handles color blends and view kicks
===============
*/
void P_DamageFeedback (edict_t *player)
{
	gclient_t	*client;
	float	side;
	float	realcount, count, kick;
	vec3_t	v;
	int		r, l;
	static	vec3_t	power_color = {0.0, 1.0, 0.0};
	static	vec3_t	acolor = {1.0, 1.0, 1.0};
	static	vec3_t	bcolor = {1.0, 0.0, 0.0};

	client = player->client;

	// flash the backgrounds behind the status numbers
	client->ps.stats[STAT_FLASHES] = 0;
	if (client->damage_blood)
		client->ps.stats[STAT_FLASHES] |= 1;
	if (client->damage_armor && !(player->flags & FL_GODMODE) && (client->invincible_framenum <= level.framenum))
		client->ps.stats[STAT_FLASHES] |= 2;

	// total points of damage shot at the player this frame
	count = (client->damage_blood + client->damage_armor + client->damage_parmor);
	if (count == 0)
		return;		// didn't take any damage

	// start a pain animation if still in the player model
	if (client->anim_priority < ANIM_PAIN && player->s.modelindex == 255)
	{
		static int		i;

		client->anim_priority = ANIM_PAIN;
		if (client->ps.pmove.pm_flags & PMF_DUCKED)
		{
			player->s.frame = FRAME_crpain1-1;
			client->anim_end = FRAME_crpain4;
		}
		else
		{
			i = (i+1)%3;
			switch (i)
			{
			case 0:
				player->s.frame = FRAME_pain101-1;
				client->anim_end = FRAME_pain104;
				break;
			case 1:
				player->s.frame = FRAME_pain201-1;
				client->anim_end = FRAME_pain204;
				break;
			case 2:
				player->s.frame = FRAME_pain301-1;
				client->anim_end = FRAME_pain304;
				break;
			}
		}
	}

	realcount = count;
	if (count < 10)
		count = 10;	// always make a visible effect

	// play an apropriate pain sound
	if ((level.time > player->pain_debounce_time) && !(player->flags & FL_GODMODE) && (client->invincible_framenum <= level.framenum))
	{
		r = 1 + (rand()&1);
		player->pain_debounce_time = level.time + 0.7;
		if (player->health < 25)
			l = 25;
		else if (player->health < 50)
			l = 50;
		else if (player->health < 75)
			l = 75;
		else
			l = 100;

		gi.sound (player, CHAN_VOICE, gi.soundindex(va("*pain%i_%i.wav", l, r)), 1, ATTN_NORM, 0);
	}

	// the total alpha of the blend is always proportional to count
	if (client->damage_alpha < 0)
		client->damage_alpha = 0;
	client->damage_alpha += count*0.01;
	if (client->damage_alpha < 0.2)
		client->damage_alpha = 0.2;
	if (client->damage_alpha > 0.6)
		client->damage_alpha = 0.6;		// don't go too saturated

	// the color of the blend will vary based on how much was absorbed
	// by different armors
	VectorClear (v);
	if (client->damage_parmor)
		VectorMA (v, (float)client->damage_parmor/realcount, power_color, v);
	if (client->damage_armor)
		VectorMA (v, (float)client->damage_armor/realcount,  acolor, v);
	if (client->damage_blood)
		VectorMA (v, (float)client->damage_blood/realcount,  bcolor, v);
	VectorCopy (v, client->damage_blend);


	//
	// calculate view angle kicks
	//
	kick = abs(client->damage_knockback);
	if (kick && player->health > 0)	// kick of 0 means no view adjust at all
	{
		kick = kick * 100 / player->health;

		if (kick < count*0.5)
			kick = count*0.5;
		if (kick > 50)
			kick = 50;

		VectorSubtract (client->damage_from, player->s.origin, v);
		VectorNormalize (v);
		
		side = DotProduct (v, right);
		client->v_dmg_roll = kick*side*0.3;
		
		side = -DotProduct (v, forward);
		client->v_dmg_pitch = kick*side*0.3;

		client->v_dmg_time = level.time + DAMAGE_TIME;
	}

	//
	// clear totals
	//
	client->damage_blood = 0;
	client->damage_armor = 0;
	client->damage_parmor = 0;
	client->damage_knockback = 0;
}




/*
===============
SV_CalcViewOffset

Auto pitching on slopes?

  fall from 128: 400 = 160000
  fall from 256: 580 = 336400
  fall from 384: 720 = 518400
  fall from 512: 800 = 640000
  fall from 640: 960 = 

  damage = deltavelocity*deltavelocity  * 0.0001

===============
*/
void SV_CalcViewOffset (edict_t *ent)
{
	float		*angles;
	float		bob, temp;
	float		ratio;
	float		delta;
	vec3_t		v;
	qboolean water =  (ent->waterlevel>1||sv_waterlevel->value);

//===================================

	// base angles
	angles = ent->client->ps.kick_angles;

	// if dead, fix the angle and don't add any kick

	if (ent->deadflag&&!ent->killer)
	{
		VectorClear (angles);

		ent->client->ps.viewangles[ROLL] = 40;
		ent->client->ps.viewangles[PITCH] = -15;
		ent->client->ps.viewangles[YAW] = ent->client->killer_yaw;

	}	
	else if (!ent->deadflag||ent->killer)
	{
		// add angles based on weapon kick

		VectorCopy (ent->client->kick_angles, angles);

		// add angles based on damage kick

		ratio = (ent->client->v_dmg_time - level.time) / DAMAGE_TIME;
		if (ratio < 0)
		{
			ratio = 0;
			ent->client->v_dmg_pitch = 0;
			ent->client->v_dmg_roll = 0;
		}
		angles[PITCH] += ratio * ent->client->v_dmg_pitch;
		angles[ROLL] += ratio * ent->client->v_dmg_roll;

		// add pitch based on fall kick

		ratio = (ent->client->fall_time - level.time) / FALL_TIME;
		if (ratio < 0)
			ratio = 0;
		angles[PITCH] += ratio * ent->client->fall_value;

		// add angles based on velocity

		delta = DotProduct (ent->velocity, forward);
		angles[PITCH] += delta*run_pitch->value;
		
		delta = DotProduct (ent->velocity, right);
		angles[ROLL] += delta*run_roll->value;

		// add angles based on bob

		delta = bobfracsin * bob_pitch->value * xyspeed;
		if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
			delta *= 6;		// crouching
		angles[PITCH] += delta;
		delta = bobfracsin * bob_roll->value * xyspeed;
		if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
			delta *= 6;		// crouching
		if (bobcycle & 1)
			delta = -delta;
		angles[ROLL] += delta;
	}
//===================================

	// base origin

	VectorClear (v);

	// add view height

	v[2] += ent->viewheight;

	// add fall height

	ratio = (ent->client->fall_time - level.time) / FALL_TIME;
	if (ratio < 0)
		ratio = 0;
	v[2] -= ratio * ent->client->fall_value * 0.4;

	// add bob height

	bob = bobfracsin * xyspeed * bob_up->value;
	if (bob > 6)
		bob = 6;
	//gi.DebugGraph (bob *2, 255);
	v[2] += bob;

	// add kick offset

	VectorAdd (v, ent->client->kick_origin, v);

	// absolutely bound offsets
	// so the view can never be outside the player box

        if (!ent->client->chasetoggle)
        {
			if (v[0] < -14)
				v[0] = -14;
			else if (v[0] > 14)
				v[0] = 14;
			if (v[1] < -14)
				v[1] = -14;
			else if (v[1] > 14)
				v[1] = 14;
			if (v[2] < -22)
				v[2] = -22;
			else if (v[2] > 30 && !water)
				v[2] = 30;
        }
        else
        { 
           VectorSet (v, 0, 0, 0);
           if (ent->client->chasecam != NULL)
           {
	           ent->client->ps.pmove.origin[0] = ent->client->chasecam->s.origin[0]*8;
               ent->client->ps.pmove.origin[1] = ent->client->chasecam->s.origin[1]*8;
               ent->client->ps.pmove.origin[2] = ent->client->chasecam->s.origin[2]*8;
            }
        }

	VectorCopy (v, ent->client->ps.viewoffset);
}

/*
==============
SV_CalcGunOffset
==============
*/
void SV_CalcGunOffset (edict_t *ent)
{
	int		i;
	float	delta;

	// gun angles from bobbing
	ent->client->ps.gunangles[ROLL] = xyspeed * bobfracsin * 0.005;
	ent->client->ps.gunangles[YAW] = xyspeed * bobfracsin * 0.01;
	if (bobcycle & 1)
	{
		ent->client->ps.gunangles[ROLL] = -ent->client->ps.gunangles[ROLL];
		ent->client->ps.gunangles[YAW] = -ent->client->ps.gunangles[YAW];
	}

	ent->client->ps.gunangles[PITCH] = xyspeed * bobfracsin * 0.005;

	// gun angles from delta movement
	for (i=0 ; i<3 ; i++)
	{
		delta = ent->client->oldviewangles[i] - ent->client->ps.viewangles[i];
		if (delta > 180)
			delta -= 360;
		if (delta < -180)
			delta += 360;
		if (delta > 45)
			delta = 45;
		if (delta < -45)
			delta = -45;
		if (i == YAW)
			ent->client->ps.gunangles[ROLL] += 0.1*delta;
		ent->client->ps.gunangles[i] += 0.2 * delta;
	}

	// gun height
	VectorClear (ent->client->ps.gunoffset);
//	ent->ps->gunorigin[2] += bob;

	// gun_x / gun_y / gun_z are development tools
	for (i=0 ; i<3 ; i++)
	{
		ent->client->ps.gunoffset[i] += forward[i]*(gun_y->value);
		ent->client->ps.gunoffset[i] += right[i]*gun_x->value;
		ent->client->ps.gunoffset[i] += up[i]* (-gun_z->value);
	}
}


/*
=============
SV_AddBlend
=============
*/
void SV_AddBlend (float r, float g, float b, float a, float *v_blend)
{
	float	a2, a3;

	if (a <= 0)
		return;
	a2 = v_blend[3] + (1-v_blend[3])*a;	// new total alpha
	a3 = v_blend[3]/a2;		// fraction of color from old

	v_blend[0] = v_blend[0]*a3 + r*(1-a3);
	v_blend[1] = v_blend[1]*a3 + g*(1-a3);
	v_blend[2] = v_blend[2]*a3 + b*(1-a3);
	v_blend[3] = a2;
}


/*
=============
SV_CalcBlend
=============
*/
void SV_CalcBlend (edict_t *ent)
{
	int		contents;
	vec3_t	vieworg;
	int		remaining;
	float		h_temp;

	ent->client->ps.blend[0] = ent->client->ps.blend[1] = 
		ent->client->ps.blend[2] = ent->client->ps.blend[3] = 0;

	// add for contents

    if (ent->client->chasetoggle)
	    VectorCopy (ent->client->chasecam->s.origin, vieworg);
    else
        VectorAdd (ent->s.origin, ent->client->ps.viewoffset, vieworg);

	contents = gi.pointcontents (vieworg);

	if (ent->killer)
	{
		if (sv_waterlevel->value)
		{
			contents |= CONTENTS_WATER;
			SV_AddBlend (0.2, 0.2, 0.6, 0.3, ent->client->ps.blend);
		}
		return;
	}

	//I put this here for the hell of it -psychospaz
	if (ent->client->laser_on && !ent->client->resp.spectator)
	{
		weapon_fire_laser (ent);
	}
	//this too - psychospaz

	if (ent->client->flashlight_on && !ent->client->resp.spectator)
	{
		weapon_flashlight_fire (ent);
	}

	if (ent->client->bfg_firing)	//this make bfg laser work!!!
	{
		weapon_fire_laser_bfg (ent);
		AddKick (ent, forward, 3);
		ent->client->bfg_firing--;
	}

	if (sv_waterlevel->value)
	{
		if (ent->flashbanged)	//for FBed suckas
		{
			h_temp=(ent->flashbanged>50)?10:ent->flashbanged/50;

			SV_AddBlend (1, 1, 1, h_temp, ent->client->ps.blend);
			ent->flashbanged--;
		}

		contents |= CONTENTS_WATER;
		SV_AddBlend (0.2, 0.2, 0.6, 0.3, ent->client->ps.blend);
		return;
	}
	else
	{
	
		if (contents & (CONTENTS_LAVA|CONTENTS_SLIME|CONTENTS_WATER) )
			ent->client->ps.rdflags |= RDF_UNDERWATER;
		else
			ent->client->ps.rdflags &= ~RDF_UNDERWATER;

		if (contents & (CONTENTS_SOLID|CONTENTS_LAVA))
			SV_AddBlend (1.0, 0.4, 0.0, 0.85, ent->client->ps.blend); //SV_AddBlend (1.0, 0.3, 0.0, 0.6, ent->client->ps.blend);
		else if (contents & CONTENTS_SLIME)
			SV_AddBlend (0.0, 0.1, 0.05, 0.6, ent->client->ps.blend);
		else if (contents & CONTENTS_WATER)
		{
			if (ent->client->goggles)
				SV_AddBlend (0, 0, 0.5, 0.3, ent->client->ps.blend);
			else if (ent->client->aquasuit)
				SV_AddBlend (-0.5, -0.5, 0, 0.5, ent->client->ps.blend);
			else
				SV_AddBlend (0.1, 0.5, 0.7, 0.7, ent->client->ps.blend);
		}
		else
		{
			if (ent->client->goggles)
				SV_AddBlend (0.5, 0.3, 0.3, 0.3, ent->client->ps.blend);
			if (ent->client->aquasuit)
				SV_AddBlend (-0.5, -1.0, -1.0, 0.3, ent->client->ps.blend);
		}
	}
	
	// add for powerups
	if (ent->client->quad_framenum > level.framenum)
	{
		remaining = ent->client->quad_framenum - level.framenum;
		if (remaining == 30)	// beginning to fade
			gi.sound(ent, CHAN_ITEM, gi.soundindex("items/damage2.wav"), 1, ATTN_NORM, 0);
		if (remaining > 30 || (remaining & 4) )
			SV_AddBlend (0, 0, 1, 0.08, ent->client->ps.blend);
	}
	else if (ent->client->invincible_framenum > level.framenum)
	{
		remaining = ent->client->invincible_framenum - level.framenum;
		if (remaining == 30)	// beginning to fade
			gi.sound(ent, CHAN_ITEM, gi.soundindex("items/protect2.wav"), 1, ATTN_NORM, 0);
		if (remaining > 30 || (remaining & 4) )
			SV_AddBlend (1, 0, 1, 0.1, ent->client->ps.blend); //SV_AddBlend (1, 1, 0, 0.08, ent->client->ps.blend);
	}
	else if (ent->client->enviro_framenum > level.framenum)
	{
		remaining = ent->client->enviro_framenum - level.framenum;
		if (remaining == 30)	// beginning to fade
			gi.sound(ent, CHAN_ITEM, gi.soundindex("items/airout.wav"), 1, ATTN_NORM, 0);
		if (remaining > 30 || (remaining & 4) )
			SV_AddBlend (0, 1, 0, 0.08, ent->client->ps.blend);
	}
	else if (ent->client->breather_framenum > level.framenum)
	{
		remaining = ent->client->breather_framenum - level.framenum;
		if (remaining == 30)	// beginning to fade
			gi.sound(ent, CHAN_ITEM, gi.soundindex("items/airout.wav"), 1, ATTN_NORM, 0);
		if (remaining > 30 || (remaining & 4) )
			SV_AddBlend (0.4, 0.4, 0.1, 0.04, ent->client->ps.blend);
	}

	if (ent->client->aquasuit)//||ent->client->goggles)
		ent->client->ps.rdflags |= RDF_IRGOGGLES;
	else
		ent->client->ps.rdflags &= ~RDF_IRGOGGLES;
	
	//very low health makes view bloody if not in lava
	//cause lava makes red purple :)
	if (!(contents & (CONTENTS_SOLID|CONTENTS_LAVA))&&!ent->client->aquasuit&&sv_bloodyview->value)
		if (ent->health < 75)
		{
			h_temp = ent->health;
			if (h_temp<0)
				h_temp = 0;
			h_temp = (1.75)*(0.5-(h_temp/100));
			
			if (!ent->client->health_dir)
				ent->client->health_dir=1;

			if (ent->client->health_view>5)
			{
				ent->client->health_view=5;
				ent->client->health_dir=-1;
			}
			else if (ent->client->health_view<0)
			{
				ent->client->health_view=0;
				ent->client->health_dir=1;
			}

			ent->client->health_view += ent->client->health_dir;
			//ent->client->health_view *= 0.5;

			SV_AddBlend (0.4+(ent->client->health_view*0.1), 0, 0, h_temp, ent->client->ps.blend);
			if (ent->health < 30)
				ent->client->ps.rdflags |= RDF_UNDERWATER;
		}

	//oh don't forget this - psychospaz
	if (ent->linked_flame)
		SV_AddBlend (1.0, 0.4, 0.0, 0.65, ent->client->ps.blend);

	if (ent->flashbanged)	//for FBed suckas
	{
		h_temp=(ent->flashbanged>50)?10:ent->flashbanged/50;

		SV_AddBlend (1, 1, 1, h_temp, ent->client->ps.blend);
		ent->flashbanged--;
	}

	// add for damage
	if (ent->client->damage_alpha > 0)
		SV_AddBlend (ent->client->damage_blend[0],ent->client->damage_blend[1]
		,ent->client->damage_blend[2], ent->client->damage_alpha, ent->client->ps.blend);

	if (ent->client->bonus_alpha > 0)
		SV_AddBlend (0.85, 0.7, 0.3, ent->client->bonus_alpha, ent->client->ps.blend);

	// drop the damage value
	ent->client->damage_alpha -= 0.06;
	if (ent->client->damage_alpha < 0)
		ent->client->damage_alpha = 0;

	// drop the bonus value
	ent->client->bonus_alpha -= 0.1;
	if (ent->client->bonus_alpha < 0)
		ent->client->bonus_alpha = 0;

//	SV_AddBlend (0, 1, 0, -0.5, ent->client->ps.blend);
}


/*
=================
P_FallingDamage
=================
*/
void P_FallingDamage (edict_t *ent)
{
	float	delta;
	int		deltamax;
	int		damage;
	vec3_t	dir;

	if (sv_fall->value>0)
		deltamax= 20 * 1/sv_fall->value;
	else
		deltamax = 10000;

	if ((ent->client->aquasuit)||(ent->client->grapple==2)||(ent->Move_up<0))
		deltamax *= 3/2;

	if (ent->client->grapple || abs(ent->client->wallrunning) || ent->client->climbing)
		return;	

	if ((sv_waterlevel->value||(ent->client->goggles && ent->waterlevel>1)||(ent->client->jets)))
		return;

	if (ent->movetype == MOVETYPE_NOCLIP)
		return;

	if ((ent->client->oldvelocity[2] < 0) && (ent->velocity[2] > ent->client->oldvelocity[2]) && (!ent->groundentity))
	{
		delta = ent->client->oldvelocity[2];
	}
	else
	{
		if (!ent->groundentity)
			return;
		delta = ent->velocity[2] - ent->client->oldvelocity[2];
	}
	delta = delta*delta * 0.0001;

	// never take falling damage if completely underwater
	if (ent->waterlevel == 3)
		return;
	if (ent->waterlevel == 2)
		delta *= 0.25;
	if (ent->waterlevel == 1)
		delta *= 0.5;

	if (ent->client)
		if ((ent->client->aquasuit)||(ent->client->grapple == 2))
			delta *= 0.75;

	if (delta < 1)
		return;

	if (delta < deltamax)	//15)
	{
		ent->s.event = EV_FOOTSTEP;
		return;
	}

	ent->client->fall_value = delta*0.5;
	if (ent->client->fall_value > 40)
		ent->client->fall_value = 40;
	ent->client->fall_time = level.time + FALL_TIME;

	if (delta > deltamax) //20)	//(delta > 30)
	{
		if (ent->health > 0)
		{
			if (delta > deltamax*5)
				ent->s.event = EV_FALLFAR;
			else
				ent->s.event = EV_FALL;
		}
		ent->pain_debounce_time = level.time;	// no normal pain sound
		damage = (delta-30); //(delta-30)/2;
		if (damage < 1)
			damage = 1;
		VectorSet (dir, 0, 0, 1);


		if (ent->Move_up<0&&!ent->client->stunts)
			ent->client->stunts=-70;

		damage*= sv_fall->value * 5;

		if (!deathmatch->value || !((int)dmflags->value & DF_NO_FALLING) )
			T_Damage (ent, world, world, dir, ent->s.origin, vec3_origin, damage, 0, 0, MOD_FALLING);
	}
	else
	{
		ent->s.event = EV_FALLSHORT;
		return;
	}
}



/*
=============
P_WorldEffects
=============
*/

void bbl_think (edict_t *self)
{
	int i=0;
	edict_t	*findMark=NULL;

	self->timer++;
	
	if (self->timer>100)
		BulletMarkThink(self);

	if ((!self->waterlevel&&!sv_waterlevel->value)&&self->s.frame==1)
	{
		self->movetype = MOVETYPE_NONE;
		self->s.origin[2]+= 4;
		self->s.frame--;
		self->s.effects = EF_SPHERETRANS;
		self->s.renderfx = 0;
		
	//	self->s.effects = 0;
	//	self->s.renderfx = RF_TRANSLUCENT;

	}

	self->think = bbl_think;
	self->nextthink = level.time;
}

void SP_Bubble (edict_t *ent, vec3_t start)
{
	edict_t *bbl;

	if ((int)sv_bulletmarks->value<=0)
		return;

	if (sv_bulletmarks->value <= bulletmarks)
		BulletMarkThink(bulletptr[0]);

	bbl = G_Spawn();

	VectorCopy (start, bbl->s.origin);
	VectorCopy (start, bbl->s.old_origin);

	if (sv_serversideonly->value)
		gi.setmodel (bbl, "sprites/s_bubble.sp2");
	else
		gi.setmodel (bbl, "sprites/s_bubble2.sp2");

//	bbl->s.effects = EF_SPHERETRANS;
//	bbl->s.renderfx = 0;
	
	bbl->s.effects = 0;
	bbl->s.renderfx = RF_TRANSLUCENT;

	bbl->solid = SOLID_BBOX;
	bbl->svflags = SVF_DEADMONSTER;
	bbl->clipmask = MASK_SHOT;
	bbl->takedamage = DAMAGE_NO;
	bbl->floater = 1;
	bbl->movetype = MOVETYPE_FLYMISSILE;
	bbl->svflags |= SVF_MONSTER;
	bbl->velocity[1] = random() * 10 - 5;
	bbl->velocity[2] = 20 + random() * 10;
	bbl->velocity[3] = random() * 10 - 5;
	bbl->owner = ent;
	bbl->timer = 0;
	bbl->think = bbl_think; //G_FreeEdict;
	bbl->nextthink = level.time; // + 2;
	bbl->s.frame = 1;
	bbl->waterlevel = 1;
	gi.linkentity (bbl);

	bulletptr[bulletmarks] = bbl;
	bulletmarks++;
}

void P_WorldEffects (void)
{
	vec3_t		bbl_pos;
	qboolean	breather;
	qboolean	envirosuit;
	qboolean	aquasuit;
	qboolean	goggles;
	int			waterlevel, old_waterlevel;

	if (current_player->movetype == MOVETYPE_NOCLIP)
	{
		current_player->air_finished = level.time + 12;	// don't need air
		return;
	}

	waterlevel = current_player->waterlevel;
	old_waterlevel = current_client->old_waterlevel;
	current_client->old_waterlevel = waterlevel;

	breather   = current_client->breather_framenum > level.framenum;
	envirosuit = current_client->enviro_framenum > level.framenum;
	aquasuit   = current_client->aquasuit;
	goggles    = current_client->goggles;
	//
	// if just entered a water volume, play a sound
	//
	if (!old_waterlevel && waterlevel)
	{
		PlayerNoise(current_player, current_player->s.origin, PNOISE_SELF);
		if (current_player->watertype & CONTENTS_LAVA)
			gi.sound (current_player, CHAN_BODY, gi.soundindex("player/lava_in.wav"), 1, ATTN_NORM, 0);
		else if (current_player->watertype & CONTENTS_SLIME)
			gi.sound (current_player, CHAN_BODY, gi.soundindex("player/watr_in.wav"), 1, ATTN_NORM, 0);
		else if (current_player->watertype & CONTENTS_WATER)
			gi.sound (current_player, CHAN_BODY, gi.soundindex("player/watr_in.wav"), 1, ATTN_NORM, 0);
		current_player->flags |= FL_INWATER;

		// clear damage_debounce, so the pain sound will play immediately
		current_player->damage_debounce_time = level.time - 1;
	}

	//
	// if just completely exited a water volume, play a sound
	//
	if (old_waterlevel && ! waterlevel)
	{
		PlayerNoise(current_player, current_player->s.origin, PNOISE_SELF);
		gi.sound (current_player, CHAN_BODY, gi.soundindex("player/watr_out.wav"), 1, ATTN_NORM, 0);
		current_player->flags &= ~FL_INWATER;
	}

	//
	// check for head just going under water
	//
	if (old_waterlevel != 3 && waterlevel == 3)
	{
		gi.sound (current_player, CHAN_BODY, gi.soundindex("player/watr_un.wav"), 1, ATTN_NORM, 0);
	}

	//
	// check for head just coming out of water
	//
	if (old_waterlevel == 3 && waterlevel != 3)
	{
		if (current_player->air_finished < level.time)
		{	// gasp for air
			gi.sound (current_player, CHAN_VOICE, gi.soundindex("player/gasp1.wav"), 1, ATTN_NORM, 0);
			PlayerNoise(current_player, current_player->s.origin, PNOISE_SELF);
		}
		else  if (current_player->air_finished < level.time + 11)
		{	// just break surface
			gi.sound (current_player, CHAN_VOICE, gi.soundindex("player/gasp2.wav"), 1, ATTN_NORM, 0);
		}
	}

	//
	// check for drowning
	//
	if ((waterlevel == 3)||sv_waterlevel->value)
	{
		// breather or envirosuit give air
		if (breather || envirosuit || aquasuit ||goggles || sv_waterlevel->value)
		{
			current_player->air_finished = level.time + 10;

			if (((int)(current_client->breather_framenum - level.framenum) % 25) == 0)
			{
				if (!current_client->breather_sound)
					gi.sound (current_player, CHAN_AUTO, gi.soundindex("player/u_breath1.wav"), 1, ATTN_NORM, 0);
				else
					gi.sound (current_player, CHAN_AUTO, gi.soundindex("player/u_breath2.wav"), 1, ATTN_NORM, 0);
				current_client->breather_sound ^= 1;
				PlayerNoise(current_player, current_player->s.origin, PNOISE_SELF);
				//FIXME: release a bubble?
					VectorCopy (current_player->s.origin, bbl_pos);
					bbl_pos[2]+=current_player->viewheight;
					SP_Bubble (current_player, bbl_pos);
				//oo oo i can do this !!!!
			}
		}

		// if out of air, start drowning
		if (current_player->air_finished < level.time)
		{	// drown!
			if (current_player->client->next_drown_time < level.time 
				&& current_player->health > 0)
			{
				current_player->client->next_drown_time = level.time + 1;

				// take more damage the longer underwater
				current_player->dmg += 2;
				if (current_player->dmg > 15)
					current_player->dmg = 15;

				// play a gurp sound instead of a normal pain sound
				if (current_player->health <= current_player->dmg)
					gi.sound (current_player, CHAN_VOICE, gi.soundindex("player/drown1.wav"), 1, ATTN_NORM, 0);
				else if (rand()&1)
					gi.sound (current_player, CHAN_VOICE, gi.soundindex("*gurp1.wav"), 1, ATTN_NORM, 0);
				else
					gi.sound (current_player, CHAN_VOICE, gi.soundindex("*gurp2.wav"), 1, ATTN_NORM, 0);
				//BUBBLE RELEASE FOR CHOKING
					//Set out bbl 1
					VectorCopy (current_player->s.origin, bbl_pos);
					bbl_pos[2]+=current_player->viewheight-5;
					SP_Bubble (current_player, bbl_pos);
					//Set out bbl 2
					VectorCopy (current_player->s.origin, bbl_pos);
					bbl_pos[2]+=current_player->viewheight;
					bbl_pos[0]+=10;
					SP_Bubble (current_player, bbl_pos);
					//Set out bbl 3
					VectorCopy (current_player->s.origin, bbl_pos);
					bbl_pos[2]+=current_player->viewheight-10;
					bbl_pos[1]+=10;
					SP_Bubble (current_player, bbl_pos);
				//BUBBLE RELEASE FINISHED
				current_player->pain_debounce_time = level.time;

				T_Damage (current_player, world, world, vec3_origin, current_player->s.origin, vec3_origin, current_player->dmg, 0, DAMAGE_NO_ARMOR, MOD_WATER);
			}
		}
	}
	else
	{
		current_player->air_finished = level.time + 12;
		current_player->dmg = 2;
	}

	//
	// check for sizzle damage
	//
	if (waterlevel && (current_player->watertype&(CONTENTS_LAVA|CONTENTS_SLIME)) )
	{
		if (current_player->watertype & CONTENTS_LAVA)
		{
			if (current_player->health > 0
				&& current_player->pain_debounce_time <= level.time
				&& current_client->invincible_framenum < level.framenum)
			{
				if (rand()&1)
					gi.sound (current_player, CHAN_VOICE, gi.soundindex("player/burn1.wav"), 1, ATTN_NORM, 0);
				else
					gi.sound (current_player, CHAN_VOICE, gi.soundindex("player/burn2.wav"), 1, ATTN_NORM, 0);
				current_player->pain_debounce_time = level.time + 1;
			}

			if (envirosuit || aquasuit)	// take 1/3 damage with envirosuit
				T_Damage (current_player, world, world, vec3_origin, current_player->s.origin, vec3_origin, 1*waterlevel, 0, 0, MOD_LAVA);
			else
			{
				T_Damage (current_player, world, world, vec3_origin, current_player->s.origin, vec3_origin, 3*waterlevel, 0, 0, MOD_LAVA);
				if (current_player->health>0 && !current_player->linked_flame)
				{
					Linked_Flame (current_player, NULL);
				}
			}
		}

		if (current_player->watertype & CONTENTS_SLIME)
		{
			if (!envirosuit && !aquasuit)
			{	// no damage from slime with envirosuit
				T_Damage (current_player, world, world, vec3_origin, current_player->s.origin, vec3_origin, 1*waterlevel, 0, 0, MOD_SLIME);
			}
		}
	}
	//
	// check for flame damage
	//
	else if (current_player->linked_flame)
	{
		if (current_player->health > 0
			&& current_player->pain_debounce_time <= level.time
			&& current_client->invincible_framenum < level.framenum)
		{
			if (rand()&1)
				gi.sound (current_player, CHAN_VOICE, gi.soundindex("player/burn1.wav"), 1, ATTN_NORM, 0);
			else
				gi.sound (current_player, CHAN_VOICE, gi.soundindex("player/burn2.wav"), 1, ATTN_NORM, 0);
			current_player->pain_debounce_time = level.time + 1;
		}

	}
}


/*
===============
G_SetClientEffects
===============
*/
void G_SetClientEffects (edict_t *ent)
{
	int		pa_type;
	int		remaining;

	ent->s.effects = 0;
	ent->s.renderfx = 0;

	if (ent->health<=0)
	{
		ent->s.renderfx = RF_BEAM;
		return;
	}


	if (ent->health <= 0 || level.intermissiontime)
		return;

	if (ent->client->kami==666)
	{
		ent->s.effects	=	EF_TELEPORTER;
		ent->s.renderfx	=	RF_SHELL_DOUBLE;
		return;
	}

	if (sv_teams->value && deathmatch->value)
		if (ent->TeamName>0)
		{
			ent->s.effects = EF_COLOR_SHELL;
			switch (ent->TeamName)
			{
				case 1:
					ent->s.renderfx = RF_SHELL_RED;		
					break;
				case 2:
					ent->s.renderfx = RF_SHELL_RED|RF_SHELL_GREEN;		
					break;		
				case 3:
					ent->s.renderfx = RF_SHELL_RED|RF_SHELL_BLUE;		
					break;	
				case 4:
					ent->s.renderfx = RF_SHELL_BLUE;		
					break;
				case 5:
					ent->s.renderfx = RF_SHELL_BLUE|RF_SHELL_GREEN;		
					break;
				case 6:
					ent->s.renderfx = RF_SHELL_GREEN;		
					break;
				case 7:
					ent->s.renderfx = RF_SHELL_GREEN|RF_SHELL_RED|RF_SHELL_BLUE;		
					break;
			}
			if (ent->client->aquasuit)
				ent->s.effects	=	EF_SPHERETRANS;

			return;
		}

	if (ent->client->aquasuit)
	{
		if (VectorLength(ent->velocity)<30)
			ent->s.effects	=	EF_SPHERETRANS;
		else if (VectorLength(ent->velocity)<250)
			ent->s.renderfx	|=	RF_TRANSLUCENT;
		else if (VectorLength(ent->velocity)<500 && (int)(rand()%3)==0 )
			ent->s.renderfx	|=	RF_TRANSLUCENT;

		//ent->s.renderfx		|=	RF_SHELL_HALF_DAM|RF_SHELL_DOUBLE;
	}
	else if (!ent->linked_flame)
	{
		ent->s.effects=0;
		ent->s.renderfx=0;
		if (ent->powerarmor_time > level.time)
		{
			pa_type = PowerArmorType (ent);
			if (pa_type == POWER_ARMOR_SCREEN)
			{
				ent->s.effects |= EF_POWERSCREEN;
			}
			else if (pa_type == POWER_ARMOR_SHIELD)
			{
				ent->s.effects |= EF_COLOR_SHELL;
				ent->s.renderfx |= RF_SHELL_GREEN;
			}
		}
	}

	if (ent->client->quad_framenum > level.framenum)
	{
		remaining = ent->client->quad_framenum - level.framenum;
		if (remaining > 30 || (remaining & 4) )
			ent->s.effects |= EF_QUAD;
	}

	if (ent->client->invincible_framenum > level.framenum)
	{
		remaining = ent->client->invincible_framenum - level.framenum;
		if (remaining > 30 || (remaining & 4) )
			ent->s.effects |= EF_PENT;

		/*	ent->s.effects |= EF_COLOR_SHELL;
			ent->s.renderfx |= (RF_SHELL_RED|RF_SHELL_BLUE);*/
	}

	// show cheaters!!!
	if (ent->flags & FL_GODMODE)
	{
		ent->s.effects |= EF_COLOR_SHELL;
		ent->s.renderfx |= (RF_SHELL_RED|RF_SHELL_GREEN|RF_SHELL_BLUE);
	}

	if (!ent->client->aquasuit)
		ent->s.renderfx |= RF_IR_VISIBLE;
}

/*
EF_ROTATE	
EF_GIB			
EF_BLASTER		
EF_ROCKET		
EF_GRENADE			
EF_HYPERBLASTER		
EF_BFG				
EF_COLOR_SHELL		
EF_POWERSCREEN		
EF_ANIM01		
EF_ANIM23		
EF_ANIM_ALL		
EF_ANIM_ALLFAST	
EF_FLIES			
EF_QUAD				
EF_PENT				
EF_TELEPORTER	
EF_FLAG1			
EF_FLAG2			
EF_IONRIPPER		
EF_GREENGIB			
EF_BLUEHYPERBLASTER 
EF_SPINNINGLIGHTS	
EF_PLASMA			
EF_TRAP				
EF_TRACKER			
EF_DOUBLE			
EF_SPHERETRANS		
EF_TAGTRAIL			
EF_HALF_DAMAGE		
EF_TRACKERTRAIL		

*/

/*
===============
G_SetClientEvent
===============
*/

#define SURF_PING 1
#define SURF_GRASS 2
#define SURF_CARPT 3
#define SURF_METAL 4

qboolean strcmpwld (char *give, char *check)
{
	int i, j, givenlength=0, checklength=0;
	
	givenlength = strlen(give);
	checklength = strlen(check);

	for (i=0; i<givenlength; i++)
	{
		char checked[100];
		checked[0] = 0;
		for (j=i; j<checklength+i; j++)
		{
			Com_sprintf (checked, sizeof(checked), "%s%c", &checked, give[j]);
		}
		if (!strcmp(check, (char *)(&checked)))
			return true;
	}

	return false;
}

qboolean Surface(char *name, int type)
{
	
	switch (type)
	{
	case SURF_PING:
		if (strcmpwld (name, "support"))
			return true;
		break;
	case SURF_GRASS:
		if (strcmpwld (name, "grass"))
			return true;
		break;
	case SURF_CARPT:
		if (strcmpwld (name, "wbox"))
			return true;
		if (strcmpwld (name, "box"))
			return true;
		if (strcmpwld (name, "pip"))
			return true;
		if (strcmpwld (name, "airduc"))
			return true;
		if (strcmpwld (name, "grnx"))
			return true;
		if (strcmpwld (name, "stflr"))
			return true;
		if (strcmpwld (name, "grate"))
			return true;
		if (strcmpwld (name, "ggrat"))
			return true;
		break;
	case SURF_METAL:
		if (strcmpwld (name, "metal"))
			return true;
		if (strcmpwld (name, "bmetal"))
			return true;
		if (strcmpwld (name, "bigmet"))
			return true;
		if (strcmpwld (name, "plate"))
			return true;
		if (strcmpwld (name, "train"))
			return true;
		if (strcmpwld (name, "wmtal"))
			return true;

		break;
	}
	return false;
}

void FootPrint (edict_t *ent, vec3_t start, vec3_t dir, int type, edict_t *other);
void G_SetClientEvent (edict_t *ent)
{
	vec3_t end = { 0, 0, -200};
	trace_t tr;
	VectorMA (ent->s.origin, 50, end, end);
	tr = gi.trace (ent->s.origin, NULL, NULL, end, ent, MASK_ALL);
	if (tr.ent)
		if (tr.ent->svflags & SVF_DEADMONSTER)
			ent->client->bootblood=15;
	
	if (ent->waterlevel)
		ent->client->bootwater = 10;
	
	if (!ent->groundentity || ent->client->isOnTurret)
		return;

	if (!(sv_waterlevel->value||(ent->client->goggles && ent->waterlevel>1)||(ent->client->jets)))
		if ( (int)(current_client->bobtime+bobmove) != bobcycle)
		{
			int sound, type;
			float volume = 1;
			vec3_t end, down = { 0, 0, -1}, point, start, right;
			trace_t tr;

			volume = (float)(VectorLength(ent->velocity))/400;
			if (volume>1)
				volume = 1;
			if (ent->client->aquasuit)
				volume/=2;

			if (ent->client->bootblood)
			{
				if (ent->client->bootwater)
					ent->client->bootwater--;
				ent->client->bootblood--;
				type = 2;
				if (random()>0.5)
					gi.sound (ent, CHAN_VOICE, gi.soundindex("player/wade2.wav"), volume, ATTN_IDLE, 0);
				else
					gi.sound (ent, CHAN_VOICE, gi.soundindex("player/wade3.wav"), volume, ATTN_IDLE, 0);
			}
			else if (ent->client->bootwater)
			{
				type = 1;
				ent->client->bootwater--;
				if (random()>0.5)
					gi.sound (ent, CHAN_VOICE, gi.soundindex("player/wade2.wav"), volume, ATTN_IDLE, 0);
				else
					gi.sound (ent, CHAN_VOICE, gi.soundindex("player/wade3.wav"), volume, ATTN_IDLE, 0);
			}
			else
				type = 0;

			ent->client->foot = (ent->client->foot==1)? -1 : 1;

			AngleVectors (ent->s.angles, NULL, right, NULL);
			VectorScale(right, ent->client->foot * 5, right);
			VectorAdd(right,ent->s.old_origin, start);
			VectorMA (start, 50, down, end);
			tr = gi.trace (start, NULL, NULL, end, ent, CONTENTS_SOLID);
			VectorCopy (tr.plane.normal, point);
			AngleVectors (ent->s.angles, end, NULL, NULL);
			VectorCopy(tr.endpos, start);
		
			if (tr.ent)
				if ((tr.ent->svflags&SVF_DEADMONSTER) || tr.ent->client)
					return;

			VectorMA (ent->s.origin, 50, down, end);
			tr = gi.trace (ent->s.origin, ent->mins, ent->maxs, end, ent, CONTENTS_SOLID);

			FootPrint (ent, start, point, type, tr.ent);

			if (Surface(tr.surface->name, SURF_PING)) //sharp loud metal
			{
				if (random()<0.5)
					sound = gi.soundindex("gladiator/gldsrch1.wav");
				else
					sound = gi.soundindex("tank/tnkdeth1.wav");
				volume/=3;				
			}
			else if (Surface(tr.surface->name, SURF_GRASS)) //grass, snow etc
			{
				if (random()<0.5)
					sound = gi.soundindex("chick/chkfall1.wav");
				else
					sound = gi.soundindex("infantry/melee2.wav");
				volume/=4;				
			}
			else if (Surface(tr.surface->name, SURF_CARPT)) //carpet/soft/wood
			{
				if (random()<0.5)
					sound = gi.soundindex("mutant/step1.wav");
				else
					sound = gi.soundindex("mutant/step3.wav");
			}
			else if (Surface(tr.surface->name, SURF_METAL)) //heavy metal
			{
				sound = gi.soundindex("mutant/thud1.wav");
				volume/=3;
			}
			else
			{
				if (random()<0.25)
					sound = gi.soundindex("player/step1.wav");
				else if (random()<0.25)
					sound = gi.soundindex("player/step2.wav");
				else if (random()<0.25)
					sound = gi.soundindex("player/step3.wav");
				else
					sound = gi.soundindex("player/step4.wav");
			}		
			
			gi.sound (ent, CHAN_AUTO, sound, volume, ATTN_NORM, 0);
			gi.sound (ent, CHAN_AUTO, sound, volume, ATTN_NORM, 0);
		}
}

/*
===============
G_SetClientSound
===============
*/
void G_SetClientSound (edict_t *ent)
{
	char	*weap;

	if (ent->client->pers.game_helpchanged != game.helpchanged)
	{
		ent->client->pers.game_helpchanged = game.helpchanged;
		ent->client->pers.helpchanged = 1;
	}

	// help beep (no more than three times)
	if (ent->client->pers.helpchanged && ent->client->pers.helpchanged <= 3 && !(level.framenum&63) )
	{
		ent->client->pers.helpchanged++;
		gi.sound (ent, CHAN_VOICE, gi.soundindex ("misc/pc_up.wav"), 1, ATTN_STATIC, 0);
	}


	if (ent->client->pers.weapon)
		weap = ent->client->pers.weapon->classname;
	else
		weap = "";

	if (ent->waterlevel && (ent->watertype&(CONTENTS_LAVA|CONTENTS_SLIME)) )
		ent->s.sound = snd_fry;
/*	else if (strcmp(weap, "weapon_railgun") == 0)
		ent->s.sound = gi.soundindex("weapons/rg_hum.wav");*/
	else if (strcmp(weap, "weapon_bfg") == 0)
		ent->s.sound = gi.soundindex("weapons/bfg_hum.wav");
	else if (ent->client->weapon_sound)
		ent->s.sound = ent->client->weapon_sound;
	else
		ent->s.sound = 0;
}

/*
===============
G_SetClientFrame
===============
*/
void G_SetClientFrame (edict_t *ent)
{
	vec3_t vec;
	gclient_t	*client;
	trace_t tr;
	qboolean	duck, run;
	edict_t *oldgrountent = ent->groundentity;

	if (ent->s.modelindex != 255)
		return;		// not in the player model

	client = ent->client;

	if (!ent->waterlevel)
	{
		VectorCopy(ent->s.origin, vec);
		vec[2] -= 30;
		tr = gi.trace(ent->s.origin, ent->mins, ent->maxs, vec, ent, MASK_SOLID);
		if (tr.fraction!=1 && !ent->client->jumping)
			ent->groundentity = ent;
	}else if (ent->waterlevel>1)
		ent->groundentity = ent;		

	if (client->ps.pmove.pm_flags & PMF_DUCKED || client->stunts<-5)
		duck = true;
	else
		duck = false;

	if (xyspeed || abs(ent->client->wallrunning) || (ent->waterlevel>1))
		run = true;
	else
		run = false;

	if (abs(ent->client->wallrunning))
		ent->groundentity = ent;

	// check for stand/duck and stop/go transitions
	if (duck != client->anim_duck && client->anim_priority < ANIM_DEATH)
		goto newanim;
	if (run != client->anim_run && (client->anim_priority == ANIM_BASIC || abs(ent->client->wallrunning) || (ent->waterlevel>1)))
		goto newanim;
	if (!ent->groundentity && client->anim_priority <= ANIM_WAVE)
		goto newanim;

	if(client->anim_priority == ANIM_REVERSE)
	{
		if(ent->s.frame > client->anim_end)
		{
			ent->s.frame--;
			ent->groundentity = oldgrountent;
			return;
		}
	}
	else if (ent->s.frame < client->anim_end)
	{	// continue an animation
		ent->s.frame++;
		ent->groundentity = oldgrountent;
		return;
	}

	if (client->anim_priority == ANIM_DEATH)
		return;		// stay there
	if (client->anim_priority == ANIM_JUMP)
	{
		if (!ent->groundentity || ent->client->jets)
		{		
			ent->groundentity = oldgrountent;
			return;		// stay there
		}
		ent->client->anim_priority = ANIM_WAVE;
		ent->s.frame = FRAME_jump3;
		ent->client->anim_end = FRAME_jump6;
		ent->groundentity = oldgrountent;
		return;
	}

newanim:
	// return to either a running or standing frame
	client->anim_priority = ANIM_BASIC;
	client->anim_duck = duck;
	client->anim_run = run;

	if ((!ent->groundentity) && ent->waterlevel!=2)
	{
		client->anim_priority = ANIM_JUMP;
		if (ent->s.frame != FRAME_jump2)
			ent->s.frame = FRAME_jump1;
		client->anim_end = FRAME_jump2;
	}
	else if (run)
	{	// running
		if (duck)
		{
			ent->s.frame = FRAME_crwalk1;
			client->anim_end = FRAME_crwalk6;
		}
		else
		{
			ent->s.frame = FRAME_run1;
			client->anim_end = FRAME_run6;
		}
	}
	else
	{	// standing
		if (duck)
		{
			ent->s.frame = FRAME_crstnd01;
			client->anim_end = FRAME_crstnd19;
		}
		else
		{
			ent->s.frame = FRAME_stand01;
			client->anim_end = FRAME_stand40;
		}
	}
	ent->groundentity = oldgrountent;
}

void WaveThink (edict_t *ent)
{
	ent->nextthink = level.time;
	ent->s.frame = ent->s.skinnum++;

	if (ent->s.skinnum>4)
		G_FreeEdict(ent);
}

void AddWaves (edict_t *ent)
{
	trace_t tr;
	vec3_t top, bottom, change;
	float randadd[2], originchange;
	int i;

	if ((int)sv_bulletmarks->value<=0 || sv_serversideonly->value)
		return;

	VectorSubtract(ent->s.origin, ent->client->old_origin, change);
	originchange = VectorLength(change);

	VectorCopy(ent->s.origin, top);
	VectorCopy(ent->s.origin, bottom);

	top[2] += ent->maxs[2];
	bottom[2] += ent->mins[2];

	if (originchange<10)
		for (i=0;i<2;i++)
		{
			randadd[i] = (10-originchange) - random()*(10-originchange)*2;
			top[i]+=randadd[i];
			bottom[i]+=randadd[i];
		}

	tr = gi.trace(top, NULL, NULL, bottom, ent, MASK_WATER);

	if (tr.fraction!=1)
	{
		edict_t *splash;

		splash = G_Spawn();

		if (sv_bulletmarks->value <= bulletmarks)
			BulletMarkThink(bulletptr[0]);

		vectoangles(tr.plane.normal, splash->s.angles);
		VectorCopy(tr.endpos, splash->s.origin);

		splash->s.effects = 0;
		splash->s.renderfx = RF_TRANSLUCENT;
		splash->solid = SOLID_NOT;
		splash->svflags = SVF_DEADMONSTER;
		splash->clipmask = MASK_SHOT;
		splash->takedamage = DAMAGE_NO;
		splash->movetype = MOVETYPE_NONE;
		splash->svflags = SVF_DEADMONSTER;
		splash->think = WaveThink;
		splash->nextthink = level.time;
		splash->owner = ent;
		if (originchange<2)
			splash->s.frame = 3;
		else if (originchange<5)
			splash->s.frame = 2;
		else if (originchange<10)
			splash->s.frame = 1;		
		else
			splash->s.frame = 0;

		splash->s.skinnum = splash->s.frame;

		splash->s.modelindex = gi.modelindex("models/objects/splash/tris.md2");
		splash->classname = "clientwave";

		gi.linkentity (splash);
		bulletptr[bulletmarks] = splash;
		bulletmarks++;
	}
}

/*
=================
ClientEndServerFrame

Called for each player at the end of the server frame
and right after spawning
=================
*/
void ClientEndServerFrame (edict_t *ent)
{
	float	bobtime;
	int		i;
	edict_t *other;

	current_player = ent;
	current_client = ent->client;
	
	//THIS IS FOR PING DEPENDANT FUNCTIONS
	ent->client->MOTDrotChange = (float)(ent->client->ping/25);
	if (ent->client->MOTDrotChange<1)
		ent->client->MOTDrotChange=1;

	if (level.framenum - ent->client->resp.enterframe > 1 && !ent->configed)
	{
		stuffcmd (ent, "exec uservars.cfg");
		ent->configed = true;
	}

//	if (level.framenum - ent->client->resp.enterframe==2)
//		stuffcmd(ent, "exec uservars.cfg");

	//
	// If the origin or velocity have changed since ClientThink(),
	// update the pmove values.  This will happen when the client
	// is pushed by a bmodel or kicked by an explosion.
	// 
	// If it wasn't updated here, the view position would lag a frame
	// behind the body position when pushed -- "sinking into plats"
	//
	for (i=0 ; i<3 ; i++)
	{
		current_client->ps.pmove.origin[i] = ent->s.origin[i]*8.0;
		current_client->ps.pmove.velocity[i] = ent->velocity[i]*8.0;
	}

	//
	// If the end of unit layout is displayed, don't give
	// the player any normal movement attributes
	//
	if (level.intermissiontime)
	{
		// FIXME: add view drifting here?
		current_client->ps.blend[3] = 0;
		current_client->ps.fov = 90;
		G_SetStats (ent);
		return;
	}

	AngleVectors (ent->client->v_angle, forward, right, up);

	// burn from lava, etc
	P_WorldEffects ();

	//
	// set model angles from view angles so other things in
	// the world can tell which direction you are looking
	//
	if (!ent->killer && !ent->client->isOnTurret)
	{
		if (ent->client->v_angle[PITCH] > 180)
			ent->s.angles[PITCH] = (-360 + ent->client->v_angle[PITCH])/3;
		else
			ent->s.angles[PITCH] = ent->client->v_angle[PITCH]/3;
	}

	//this makes for cool looking angles in the air or water...

	ent->client->climbing = 0;
	ent->client->wallrunning = 0;
	if (ent->groundentity)
	{
		int offsetAmt = 2;

		if (abs(ent->client->stunts)==1)
		{
			if (ent->client->stunts==1)
				ent->client->stunts=-70-offsetAmt; //-3
			else
				ent->client->stunts=-90-offsetAmt; //-4
		}
		else if (abs(ent->client->stunts)==2)
		{
			if (ent->client->stunts==2)
				ent->client->stunts=-10-offsetAmt;
			else
				ent->client->stunts=-40-offsetAmt;
		}
		else if ((ent->client->stunts==-3 || ent->client->stunts==-4) && ent->Move_up>=0)
			/* DO NOTHING */;
		else if (ent->client->stunts<-5)
			/* DO NOTHING */;
		else
			ent->client->stunts=0;
	}
	else if (ent->waterlevel>1)
		ent->client->stunts=0;

	if (ent->client->stunt)
		CheckStunt(ent);

	flight_check  (ent); //does flight and swimming fx

	if (!ent->killer && !ent->client->isOnTurret)
	{
		ent->s.angles[ROLL] = 0;
		ent->s.angles[ROLL] = SV_CalcRoll (ent->s.angles, ent->velocity)*4;
		ent->s.angles[YAW] = ent->client->v_angle[YAW];
	}

	//PITCH(forUp/backDown) YAW(leftRot/rightRot) ROLL(leftTilt/rightTilt)
	if (ent->health && !ent->client->isOnTurret)
	{
		if (ent->waterlevel>1)
			ent->s.angles[PITCH] =  90+ent->client->v_angle[PITCH];
		else if (abs(ent->client->wallrunning))
		{
			if (ent->client->wallrunning>0) //right side
			{
				ent->s.angles[ROLL] =  90+ent->client->v_angle[ROLL];
				ent->client->kick_angles[ROLL] += 45;
			}
			else //left side
			{
				ent->s.angles[ROLL] =  -90+ent->client->v_angle[ROLL];
				ent->client->kick_angles[ROLL] -= 45;
			}
		}
		else if (ent->client->stunts!=0)
		{
			if (ent->client->stunts==1) //forward dive
				ent->s.angles[PITCH] =  60+ent->client->v_angle[PITCH];
			else if (ent->client->stunts==-1) //backwards dive
				ent->s.angles[PITCH] =  -60+ent->client->v_angle[PITCH];
			else if (ent->client->stunts==2) //right dive
				ent->s.angles[ROLL] =  -60+ent->client->v_angle[ROLL];
			else if (ent->client->stunts==-2) //left dive
				ent->s.angles[ROLL] =  60+ent->client->v_angle[ROLL];
			else if (ent->client->stunts>=10)
			{
				int RotMax = 10;
				int rot = ent->client->stunts-9;

				if (rot==RotMax) //when flip is done, stop flip
					ent->client->stunts=0;
				else
				{
					float temp = rot-(RotMax);
					temp = (temp>0)?temp:-temp;
					ent->s.angles[PITCH] = (360 * ( temp /(RotMax)) ) + ent->s.angles[PITCH];
					ent->client->stunts++;
				}
			}
			else if (ent->client->stunts<-2 && !ent->waterlevel)
			{
				int AngleQuot = 6;
				if (ent->client->stunts==-3 && !(ent->Move_up<0)) //forward prone
				{
					if (ent->client->v_angle[PITCH] > 180)
						ent->s.angles[PITCH] = 75 + (-360 + ent->client->v_angle[PITCH])/AngleQuot;
					else
						ent->s.angles[PITCH] = 75 + ent->client->v_angle[PITCH]/AngleQuot;
				}
				else if (ent->client->stunts==-4) //backwards prone
				{
					if (ent->client->v_angle[PITCH] > 180)
						ent->s.angles[PITCH] = -75 + (-360 + ent->client->v_angle[PITCH])/AngleQuot;
					else
						ent->s.angles[PITCH] = -75 + ent->client->v_angle[PITCH]/AngleQuot;
				}
				else
				{
					ent->client->stunts--;

					if ((ent->client->stunts==-20 || ent->client->stunts==-50) && !ent->client->stunt)
						ent->client->stunts=0;
					else if ((ent->client->stunts==-20 || ent->client->stunts==-50) && ent->groundentity)
					{
						ent->groundentity=NULL;
						ent->velocity[2]=200;
					}
					else if (ent->client->stunts==-30 || ent->client->stunts==-60 || ent->client->stunts==-80
						|| ent->client->stunts==-100)
						ent->client->stunts=0;

					if (ent->client->stunts>-30&&ent->client->stunts<-10) //right roll
					{	
						float rollamt = -(ent->client->stunts+10);
						ent->s.angles[ROLL] = -(360*(rollamt/10)) + ent->client->v_angle[ROLL];
					}
					else if (ent->client->stunts>-60&&ent->client->stunts<-40) //left roll
					{
						float rollamt = -(ent->client->stunts+40);
						ent->s.angles[ROLL] = (360*(rollamt/10)) + ent->client->v_angle[ROLL];
					}
					else if (ent->client->stunts>-80&&ent->client->stunts<-70) //forward roll
					{
						float rollamt = -(ent->client->stunts+70);
						ent->s.angles[PITCH] = (360*(rollamt/10)) + ent->client->v_angle[PITCH];
					}
					else if (ent->client->stunts>-100&&ent->client->stunts<-90) //backward roll
					{
						float rollamt = -(ent->client->stunts+90);
						ent->s.angles[PITCH] = -(360*(rollamt/10)) + ent->client->v_angle[PITCH];
					}
				}
			}
		}
	}

	//
	// calculate speed and cycle to be used for
	// all cyclic walking effects
	//
	xyspeed = sqrt(ent->velocity[0]*ent->velocity[0] + ent->velocity[1]*ent->velocity[1]);

	if (xyspeed < 5 || ent->client->isOnTurret)
	{
		bobmove = 0;
		current_client->bobtime = 0;	// start at beginning of cycle again
	}
	else if (ent->groundentity)
	{	// so bobbing only cycles when on ground
		if (xyspeed > 210)
			bobmove = 0.25;
		else if (xyspeed > 100)
			bobmove = 0.125;
		else
			bobmove = 0.0625;
	}
	
	bobtime = (current_client->bobtime += bobmove);

	if (current_client->ps.pmove.pm_flags & PMF_DUCKED)
		bobtime *= 4;

	bobcycle = (int)bobtime;
	bobfracsin = fabs(sin(bobtime*M_PI));

	// detect hitting the floor
	P_FallingDamage (ent);

	// apply all the damage taken this frame
	P_DamageFeedback (ent);

	// determine the view offsets
	SV_CalcViewOffset (ent);

	// determine the gun offsets
	SV_CalcGunOffset (ent);

	// determine the full screen color blend
	// must be after viewoffset, so eye contents can be
	// accurately determined
	// FIXME: with client prediction, the contents
	// should be determined by the client
	SV_CalcBlend (ent);

	// chase cam stuff
	if (ent->client->resp.spectator)
		G_SetSpectatorStats(ent);
	else
		G_SetStats (ent);
	G_CheckChaseStats(ent);

	G_SetClientFrame (ent);

	G_SetClientEvent (ent);

	G_SetClientEffects (ent);

	G_SetClientSound (ent);

	if (ent->groundentity)
		ent->client->jumping = false;

	VectorCopy (ent->velocity, ent->client->oldvelocity);
	VectorCopy (ent->client->ps.viewangles, ent->client->oldviewangles);

	// clear weapon kicks
	VectorClear (ent->client->kick_origin);
	VectorClear (ent->client->kick_angles);

	// if the scoreboard is up, update it
	if (!(deathmatch->value||coop->value))
		MakeSlowMo (ent);

	if (ent->client->showscores && !(level.framenum%ent->client->MOTDrotChange) )
	{
		DeathmatchScoreboardMessage (ent, ent->enemy);
		gi.unicast (ent, false);
	}

	if (ent->deadflag)
		ent->s.frame=0;

	if (ent->client->aquasuit)
	{
		ent->healthtimer++;
		if (ent->healthtimer==3)
		{
			ent->healthtimer=0;
			if (ent->max_health>ent->health)
				ent->health++;	//and has health regen
		}
	}

	if (ent->client->kicktime>0)
		ent->client->kicktime--;
	if (ent->client->damage_div>0)
	{
		ent->client->damage_div-=FRAMETIME;
		if (ent->client->damage_div<0)
			ent->client->damage_div=0;
	}		

	if (((int)sv_bulletmarks->value || (!deathmatch->value && !coop->value)))
	{
		if (ent->waterlevel)
			AddWaves(ent);
		
		AddShadow(ent);
		AddReflection(ent);
	}

	VectorCopy (ent->s.origin, ent->client->old_origin);
	
	//aligning muzzle flashes etc
	for (i = 1; i <= game.maxentities; i++)
	{
		other = &g_edicts[i];
		if (!other->inuse)
			continue;
		if (other->owner==ent && !strcmp(other->classname, "mzlflash"))
			other->thinklinked(other);
	}

	if (ent->client->chasetoggle == 1 && !ent->deadflag)
		CheckChasecam_Viewent(ent);
	else if (!deathmatch->value && !coop->value || sv_lowlag->value)
		ent->client->ps.pmove.pm_flags |= PMF_NO_PREDICTION;
	else
		ent->client->ps.pmove.pm_flags &= ~PMF_NO_PREDICTION;

	VectorCopy(ent->s.origin, ent->client->cl_origin);
}



