#include "g_local.h"
#include "m_player.h"

void Cmd_Notify_Cheat (edict_t *ent)
{
	gi.bprintf (PRINT_MEDIUM,"%s is trying to cheat.\n", ent->client->pers.netname);
}

char *ClientTeam (edict_t *ent)
{
	char		*p;
	static char	value[512];

	value[0] = 0;

	if (!ent->client)
		return value;

	strcpy(value, Info_ValueForKey (ent->client->pers.userinfo, "skin"));
	p = strchr(value, '/');
	if (!p)
		return value;

	if ((int)(dmflags->value) & DF_MODELTEAMS)
	{
		*p = 0;
		return value;
	}

	// if ((int)(dmflags->value) & DF_SKINTEAMS)
	return ++p;
}

qboolean OnSameTeam (edict_t *ent1, edict_t *ent2)
{
	char	ent1Team [512];
	char	ent2Team [512];

	if (sv_teams->value&&deathmatch->value)
		if (ent1->TeamName!=0 && ent2->TeamName!=0)
			if (ent1->TeamName==ent2->TeamName)
				return true;

	if (!((int)(dmflags->value) & (DF_MODELTEAMS | DF_SKINTEAMS)))
		return false;

	strcpy (ent1Team, ClientTeam (ent1));
	strcpy (ent2Team, ClientTeam (ent2));

	if (strcmp(ent1Team, ent2Team) == 0)
		return true;

	return false;
}


void SelectNextItem (edict_t *ent, int itflags)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;

	if (ent->killer)
	{
		ent->client->viewcam_dist=0;
		ChaseCamNextMonster(ent);
	}

	if (ent->health<=0)
	{
		//gi.cprintf (ent, PRINT_HIGH, "You must be alive to use this command\n");
		return;
	}

	cl = ent->client;

	if (cl->chase_target) {
		ChaseNext(ent);
		return;
	}

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (cl->pers.selected_item + i)%MAX_ITEMS;
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (!(it->flags & itflags))
			continue;

		cl->pers.selected_item = index;
		return;
	}

	cl->pers.selected_item = -1;
}

void SelectPrevItem (edict_t *ent, int itflags)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;

	if (ent->killer)
	{
		ent->client->viewcam_dist=0;
		ChaseCamPrevMonster(ent);
	}

	if (ent->health<=0)
	{
		//gi.cprintf (ent, PRINT_HIGH, "You must be alive to use this command\n");
		return;
	}

	cl = ent->client;

	if (cl->chase_target) {
		ChasePrev(ent);
		return;
	}

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (cl->pers.selected_item + MAX_ITEMS - i)%MAX_ITEMS;
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (!(it->flags & itflags))
			continue;

		cl->pers.selected_item = index;
		return;
	}

	cl->pers.selected_item = -1;
}

void ValidateSelectedItem (edict_t *ent)
{
	gclient_t	*cl;

	if (ent->health<=0)
	{
		//gi.cprintf (ent, PRINT_HIGH, "You must be alive to use this command\n");
		return;
	}

	cl = ent->client;

	if (cl->pers.inventory[cl->pers.selected_item])
		return;		// valid

	SelectNextItem (ent, -1);
}


//=================================================================================

/*
=================
Cmd_Flashlight_f
=================
*/
void Cmd_Flashlight_f (edict_t *ent)
{
	if (ent->health<=0)
	{
		//gi.cprintf (ent, PRINT_HIGH, "You must be alive to use this command\n");
		return;
	}

	if (ent->client->flashlight_on == 1)
		ent->client->flashlight_on = 0;
	else
		ent->client->flashlight_on = 1;
}

/*
==================
Cmd_Give_f

Give items to a client
==================
*/
void Cmd_Give_f (edict_t *ent)
{
	char		*name;
	gitem_t		*it;
	int			index;
	int			i;
	qboolean	give_all;
	edict_t		*it_ent;

	if (ent->health<=0)
	{
		//gi.cprintf (ent, PRINT_HIGH, "You must be alive to use this command\n");
		return;
	}

	gi.bprintf (PRINT_MEDIUM,"%s is a cheating bastard.\n", ent->client->pers.netname);

	name = gi.args();

	if (Q_stricmp(name, "all") == 0)
		give_all = true;
	else
		give_all = false;

	if (give_all || Q_stricmp(gi.argv(1), "health") == 0)
	{
		if (gi.argc() == 3)
			ent->health = atoi(gi.argv(2));
		else
			ent->health = ent->max_health;
		if (!give_all)
			return;
	}

	if (give_all || Q_stricmp(name, "weapons") == 0)
	{
		for (i=0 ; i<game.num_items ; i++)
		{
			it = itemlist + i;
			if (!it->pickup)
				continue;
			if (!(it->flags & IT_WEAPON))
				continue;
			ent->client->pers.inventory[i] += 1;
		}
		if (!give_all)
			return;
	}

	if (give_all || Q_stricmp(name, "ammo") == 0)
	{
		for (i=0 ; i<game.num_items ; i++)
		{
			it = itemlist + i;
			if (!it->pickup)
				continue;
			if (!(it->flags & IT_AMMO))
				continue;
			Add_Ammo (ent, it, 1000);
		}
		if (!give_all)
			return;
	}

	if (give_all || Q_stricmp(name, "armor") == 0)
	{
		gitem_armor_t	*info;

		it = FindItem("Jacket Armor");
		ent->client->pers.inventory[ITEM_INDEX(it)] = 0;

		it = FindItem("Combat Armor");
		ent->client->pers.inventory[ITEM_INDEX(it)] = 0;

		it = FindItem("Body Armor");
		info = (gitem_armor_t *)it->info;
		ent->client->pers.inventory[ITEM_INDEX(it)] = info->max_count;

		if (!give_all)
			return;
	}

/*	if (give_all || Q_stricmp(name, "Power Shield") == 0)
	{
		it = FindItem("Power Shield");
		it_ent = G_Spawn();
		it_ent->classname = it->classname;
		SpawnItem (it_ent, it);
		Touch_Item (it_ent, ent, NULL, NULL);
		if (it_ent->inuse)
			G_FreeEdict(it_ent);

		if (!give_all)
			return;
	}*/

	if (give_all)
	{
		for (i=0 ; i<game.num_items ; i++)
		{
			it = itemlist + i;
			if (!it->pickup)
				continue;
			if (it->flags & (IT_ARMOR|IT_WEAPON|IT_AMMO))
				continue;
			ent->client->pers.inventory[i] = 1;
		}
		return;
	}

	it = FindItem (name);
	if (!it)
	{
		name = gi.argv(1);
		it = FindItem (name);
		if (!it)
		{
			gi.cprintf (ent, PRINT_HIGH, "unknown item\n");
			return;
		}
	}

	if (!it->pickup)
	{
		gi.cprintf (ent, PRINT_HIGH, "non-pickup item\n");
		return;
	}

	index = ITEM_INDEX(it);

	if (it->flags & IT_AMMO)
	{
		if (gi.argc() == 3)
			ent->client->pers.inventory[index] = atoi(gi.argv(2));
		else
			ent->client->pers.inventory[index] += it->quantity;
	}
	else
	{
		it_ent = G_Spawn();
		it_ent->classname = it->classname;
		SpawnItem (it_ent, it);
		Touch_Item (it_ent, ent, NULL, NULL);
		if (it_ent->inuse)
			G_FreeEdict(it_ent);
	}
}

/*
==================
Cmd_God_f

Sets client to godmode

argv(0) god
==================
*/
void Cmd_God_f (edict_t *ent)
{
	char	*msg;

	if (ent->health<=0)
	{
		//gi.cprintf (ent, PRINT_HIGH, "You must be alive to use this command\n");
		return;
	}

	if (deathmatch->value && !sv_cheats->value)
	{
		gi.cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	ent->flags ^= FL_GODMODE;
	if (!(ent->flags & FL_GODMODE) )
		msg = "godmode OFF\n";
	else
		msg = "godmode ON\n";

	gi.cprintf (ent, PRINT_HIGH, msg);
}


/*
==================
Cmd_Notarget_f

Sets client to notarget

argv(0) notarget
==================
*/
void Cmd_Notarget_f (edict_t *ent)
{
	char	*msg;

/*	if (deathmatch->value && !sv_cheats->value)
	{
		gi.cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}*/

	ent->flags ^= FL_NOTARGET;
	if (!(ent->flags & FL_NOTARGET) )
		msg = "notarget OFF\n";
	else
		msg = "notarget ON\n";

	gi.cprintf (ent, PRINT_HIGH, msg);
}


/*
==================
Cmd_Noclip_f

argv(0) noclip
==================
*/
void Cmd_Noclip_f (edict_t *ent)
{
	char	*msg;

	if (deathmatch->value && !sv_cheats->value)
	{
		gi.cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	if (ent->movetype == MOVETYPE_NOCLIP)
	{
		ent->movetype = MOVETYPE_WALK;
		msg = "noclip OFF\n";
	}
	else
	{
		ent->movetype = MOVETYPE_NOCLIP;
		msg = "noclip ON\n";
	}

	gi.cprintf (ent, PRINT_HIGH, msg);
}


/*
==================
Cmd_Use_f

Use an inventory item
==================
*/
void Cmd_Use_f (edict_t *ent)
{
	int			index;
	gitem_t		*it;
	char		*s;
	char		*msg="";
	int			ismsg=0;

	s = gi.args();
	it = FindItem (s);

	if (ent->health<=0)
	{
		//gi.cprintf (ent, PRINT_HIGH, "You must be alive to use this command\n");
		return;
	}
	if (!it)
	{
		gi.cprintf (ent, PRINT_HIGH, "unknown item: %s\n", s);
		return;
	}
	if (!it->use)
	{
		gi.cprintf (ent, PRINT_HIGH, "Item is not usable.\n");
		return;
	}
	index = ITEM_INDEX(it);
	if (!ent->client->pers.inventory[index])
	{
		gi.cprintf (ent, PRINT_HIGH, "Out of item: %s\n", s);
		return;
	}
	if (ismsg==1)
		gi.cprintf (ent, PRINT_HIGH, msg);

	it->use (ent, it);
}

void Cmd_Alt_Mode_f (edict_t *ent)
{
	char		*msg="";
	int			ismsg = 0;
	int			banned = sv_banned_weapons->value;

	if (ent->health<=0)
	{
		//gi.cprintf (ent, PRINT_HIGH, "You must be alive to use this command\n");
		return;
	}

	if (ent->client->aquasuit)
	{
		fireMagic(ent);
		return;
	}

	ent->client->tazer = (ent->client->tazer) ? 10 : 0;

	if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Grenade Launcher"))
	{
		if (ent->client->grn_set==0)
		{
			ent->client->grn_set=1;
    		ent->client->grnl_set=0;
			ent->client->gren_set=2;
			msg = "Normal Gas Grenade Launcher\n";
		}
		else if (ent->client->grn_set==1)
		{
			ent->client->grn_set=2;
    		ent->client->grnl_set=0;
			ent->client->gren_set=3;
			msg = "Normal Cluster Grenade Launcher\n";
		}
		else if (ent->client->grn_set==2)
		{
			ent->client->grn_set=3;
    		ent->client->grnl_set=0;
			ent->client->gren_set=1;
			msg = "Normal Flashbang Launcher\n";
		}
		else if (ent->client->grn_set==3)
		{
			ent->client->grn_set=4;
    		ent->client->grnl_set=1;
			ent->client->gren_set=0;
			msg = "Sticky Fragmentation Grenade Launcher\n";
		}
		else if (ent->client->grn_set==4)
		{
			ent->client->grn_set=5;
    		ent->client->grnl_set=1;
			ent->client->gren_set=2;
			msg = "Sticky Gas Grenade Launcher\n";
		}
		else if (ent->client->grn_set==5)
		{
			ent->client->grn_set=6;
    		ent->client->grnl_set=1;
			ent->client->gren_set=3;
			msg = "Sticky Cluster Grenade Launcher\n";
		}
		else if (ent->client->grn_set==6)
		{
			ent->client->grn_set=7;
    		ent->client->grnl_set=1;
			ent->client->gren_set=1;
			msg = "Sticky Flashbang Launcher\n";
		}
		else
		{
			ent->client->grn_set=0;
    		ent->client->grnl_set=0;
			ent->client->gren_set=0;
			msg = "Normal Fragmentation Grenade Launcher\n";
		}											

		ismsg = 1;
	}

	if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Grenades"))
	{
		if (ent->client->gren_set==1)
		{
    		ent->client->gren_set=0;
			msg = "Fragmentation Grenades\n";
		}
		else if (ent->client->gren_set==3)
		{
			ent->client->gren_set=1;
			msg = "Flashbangs\n";
		}
		else if (ent->client->gren_set==0)
		{
			ent->client->gren_set=2;
			msg = "Gas Grenades\n";
		}
		else
		{
			ent->client->gren_set=3;
			msg = "Cluster Grenades\n";
		}

		ismsg = 1;
	}

	if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Rocket Launcher"))
	{
		if (ent->client->rock_set==1)
		{
    		ent->client->rock_set=0;
			msg = "Direct Fire Rockets\n";
		}
		else
		{
			ent->client->rock_set=1;
			msg = "Indirect Fire Rockets\n";
		}

		ismsg = 1;
	}

	if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Chaingun"))
	{
		if (ent->client->chan_set==1)
		{
    		ent->client->chan_set=0;
			msg = "Minigun\n";
		}
		else
		{
			ent->client->chan_set=1;
			msg = "Roatary Shotgun\n";
		}

		ismsg = 1;
	}

	if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Shotgun"))
	{
		if (ent->client->shot_set==1)
		{
    		ent->client->shot_set=0;
			msg = "Auto-Shotgun Shells\n";
		}
		else
		{
			ent->client->shot_set=1;
			msg = "Auto-Cannon Slugs\n";
		}

		ismsg = 1;
	}

	if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Super Shotgun"))
	{
		if (ent->client->shot_set==1)
		{
    		ent->client->shot_set=0;
			msg = "Super Shotgun Shells\n";
		}
		else
		{
			ent->client->shot_set=1;
			msg = "Super Shotgun Slugs\n";
		}

		ismsg = 1;
	}

	if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Machinegun"))
	{
		if (ent->client->mach_set==1)
		{
    		ent->client->mach_set=0;
			msg = "SubMachinegun Rapid Fire\n";
		}
		else
		{
			ent->client->mach_set=1;
			msg = "SubMachinegun Burst Fire\n";
		}

		ismsg = 1;
	}

	if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"HyperBlaster"))
	{
		if (ent->client->hypr_set==1)
		{
    		ent->client->hypr_set=0;
			ent->client->machinegun_shots=0;
			msg = "Flame Thrower\n";
		}
		else
		{
			ent->client->hypr_set=1;
			ent->client->machinegun_shots=0;
			msg = "Plasma Rifle\n";
		}

		ismsg = 1;
	}
	if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Blaster"))
	{
		if (ent->client->blst_set==1)
		{
    		ent->client->blst_set=0;
			ent->client->machinegun_shots=0;
			msg = ".50 Calibre Ammunition\n";
		}
		else
		{
			ent->client->blst_set=1;
			ent->client->machinegun_shots=0;
			msg = "Smack\n";
		}
		ismsg = 1;
	}
	if ((!sv_waterlevel->value)&&(!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Railgun")) )
	{
		if (ent->client->rail_set==1 && !(banned&NO_RAILGUN))
		{
			ent->client->rail_set=0;
			msg = ".50 Calibre Sniper Rifle\n";
		}
		else if (!sv_waterlevel->value && !(banned&NO_TAZER))
		{
			ent->client->rail_set=1;
			msg = "Tazer\n";
		}

		ismsg = 1;
	}
	if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"BFG10K"))
	{
		if (ent->client->bfg_set==2 && !(banned&NO_ROCKETBFG))
		{
			ent->client->bfg_set=0;
			msg = "Nuke Launcher Operational\n";
		}
//		else if (ent->client->bfg_set==0)
//		{
//			ent->client->bfg_set=1;
//			msg = "Guided Nuke Launcher Operational\n";
//		}
		else if (!(banned&NO_BFGLASER))
		{
    		ent->client->bfg_set=2;
			msg = "Heavy Laser Operational\n";
		}

		ismsg = 1;
	}

	if (ismsg)
		gi.cprintf (ent, PRINT_HIGH, msg);
}

/*
==================
Cmd_Drop_f

Drop an inventory item
==================
*/
void Cmd_Drop_f (edict_t *ent)
{
	int			index;
	gitem_t		*it;
	char		*s;

	if (ent->health<=0)
	{
		//gi.cprintf (ent, PRINT_HIGH, "You must be alive to use this command\n");
		return;
	}

	s = gi.args();
	it = FindItem (s);
	if (!it)
	{
		gi.cprintf (ent, PRINT_HIGH, "unknown item: %s\n", s);
		return;
	}
	if (!it->drop)
	{
		gi.cprintf (ent, PRINT_HIGH, "Item is not dropable.\n");
		return;
	}
	index = ITEM_INDEX(it);
	if (!ent->client->pers.inventory[index])
	{
		gi.cprintf (ent, PRINT_HIGH, "Out of item: %s\n", s);
		return;
	}
	if (ent->client->kami==666)
		if (!Q_strcasecmp(it->classname, "C-4 Explosive"))
		{
			gi.cprintf (ent, PRINT_HIGH, "Cannot drop C-4 once armed\n");
			return;
		}

	it->drop (ent, it);

	ValidateSelectedItem (ent);
}

/*
==================
Cmd_WeapDrop_f

Drop an inventory item
==================
*/
void Cmd_WeapDrop_f (edict_t *ent)
{
	int			index;
	gitem_t		*it;

	if (ent->health<=0)
	{
		//gi.cprintf (ent, PRINT_HIGH, "You must be alive to use this command\n");
		return;
	}

	it = ent->client->pers.weapon;
	if (!it)
	{
		gi.cprintf (ent, PRINT_HIGH, "Weapon is unavailable.\n");
		return;
	}
	if (!it->drop)
	{
		gi.cprintf (ent, PRINT_HIGH, "Weapon is not dropable.\n");
		return;
	}

	index = ITEM_INDEX(it);

	it->drop (ent, it);

	ValidateSelectedItem (ent);
}

/*
=================
Cmd_Inven_f
=================
*/
void Cmd_Inven_f (edict_t *ent)
{
	//*
	int			i;
	gclient_t	*cl;

	cl = ent->client;

	cl->showscores = false;
	cl->showhelp = false;

	if (cl->showinventory)
	{
		cl->showinventory = false;
		return;
	}

	cl->showinventory = true;

	gi.WriteByte (svc_inventory);
	for (i=0 ; i<MAX_ITEMS ; i++)
	{
		gi.WriteShort (cl->pers.inventory[i]);
	}
	gi.unicast (ent, true);
}

/*
=================
Cmd_InvUse_f
=================
*/
void Cmd_InvUse_f (edict_t *ent)
{
	gitem_t		*it;

	if (ent->health<=0)
	{
		//gi.cprintf (ent, PRINT_HIGH, "You must be alive to use this command\n");
		return;
	}

	ValidateSelectedItem (ent);

	if (ent->client->pers.selected_item == -1)
	{
		gi.cprintf (ent, PRINT_HIGH, "No item to use.\n");
		return;
	}

	it = &itemlist[ent->client->pers.selected_item];
	if (!it->use)
	{
		gi.cprintf (ent, PRINT_HIGH, "Item is not usable.\n");
		return;
	}
	it->use (ent, it);
}

/*
=================
Cmd_WeapPrev_f
=================
*/
void Cmd_WeapPrev_f (edict_t *ent)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;
	int			selected_weapon;

	if (ent->health<=0)
	{
		//gi.cprintf (ent, PRINT_HIGH, "You must be alive to use this command\n");
		return;
	}

	if (ent->client->aquasuit)
		return;

	if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Railgun"))
		ent->client->ps.fov=(ent->client->old_fov>30)?ent->client->old_fov:90;

	cl = ent->client;

	if (!cl->pers.weapon)
		return;

	selected_weapon = ITEM_INDEX(cl->pers.weapon);

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (selected_weapon + i)%MAX_ITEMS;
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (! (it->flags & IT_WEAPON) )
			continue;
		it->use (ent, it);
		if (cl->pers.weapon == it)
			return;	// successful
	}
}

/*
=================
Cmd_WeapNext_f
=================
*/
void Cmd_WeapNext_f (edict_t *ent)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;
	int			selected_weapon;

	if (ent->health<=0)
	{
		//gi.cprintf (ent, PRINT_HIGH, "You must be alive to use this command\n");
		return;
	}

	if (ent->client->aquasuit)
		return;

	if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Railgun"))
		ent->client->ps.fov=(ent->client->old_fov>30)?ent->client->old_fov:90;

	cl = ent->client;

	if (!cl->pers.weapon)
		return;

	selected_weapon = ITEM_INDEX(cl->pers.weapon);

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (selected_weapon + MAX_ITEMS - i)%MAX_ITEMS;
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (! (it->flags & IT_WEAPON) )
			continue;
		it->use (ent, it);
		if (cl->pers.weapon == it)
			return;	// successful
	}
}

/*
=================
Cmd_WeapLast_f
=================
*/
void Cmd_WeapLast_f (edict_t *ent)
{
	gclient_t	*cl;
	int			index;
	gitem_t		*it;

	if (ent->health<=0)
	{
		//gi.cprintf (ent, PRINT_HIGH, "You must be alive to use this command\n");
		return;
	}

	cl = ent->client;

	if (!cl->pers.weapon || !cl->pers.lastweapon)
		return;

	index = ITEM_INDEX(cl->pers.lastweapon);
	if (!cl->pers.inventory[index])
		return;
	it = &itemlist[index];
	if (!it->use)
		return;
	if (! (it->flags & IT_WEAPON) )
		return;
	it->use (ent, it);
}

/*
=================
Cmd_InvDrop_f
=================
*/
void Cmd_InvDrop_f (edict_t *ent)
{
	gitem_t		*it;

	if (ent->health<=0)
	{
		//gi.cprintf (ent, PRINT_HIGH, "You must be alive to use this command\n");
		return;
	}

	ValidateSelectedItem (ent);

	if (ent->client->pers.selected_item == -1)
	{
		gi.cprintf (ent, PRINT_HIGH, "No item to drop.\n");
		return;
	}

	it = &itemlist[ent->client->pers.selected_item];
	if (!it->drop)
	{
		gi.cprintf (ent, PRINT_HIGH, "Item is not dropable.\n");
		return;
	}
	if (ent->client->kami==666)
		if (!Q_strcasecmp(it->classname, "item_quad"))
		{
			gi.cprintf (ent, PRINT_HIGH, "Cannot drop C-4 once armed\n");
			return;
		}

	it->drop (ent, it);

	ValidateSelectedItem (ent);
}

/*
=================
Cmd_Kill_f
=================
*/
void Cmd_Kill_f (edict_t *ent)
{
	if (ent->health<=0)
	{
		//gi.cprintf (ent, PRINT_HIGH, "You must be alive to use this command\n");
		return;
	}
	
	if((level.time - ent->client->respawn_time) < 1)
		return;

	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("C-4 Explosive"))])
	{
		if (ent->client->kami!=666)
		{
			ent->client->pers.inventory[ITEM_INDEX(FindItem("C-4 Explosive"))]--;
			ValidateSelectedItem (ent);
			gi.cprintf (ent, PRINT_HIGH, "C4 Armed - Detonate at will.\n");
			gi.sound (ent, CHAN_WEAPON, gi.soundindex("weapons/railgr1a.wav"), 1, ATTN_NORM, 0);
			ent->client->kami=666;
			return;
		}
	}

	ent->flags &= ~FL_GODMODE;
	ent->health = 0;
	meansOfDeath = MOD_SUICIDE;
	//ent->health=-500;
	player_die (ent, ent, ent, 100000, vec3_origin);
}

/*
=================
Cmd_PutAway_f
=================
*/
void Cmd_PutAway_f (edict_t *ent)
{
	ent->client->showscores = false;
	ent->client->showhelp = false;
	ent->client->showinventory = false;
}


int PlayerSort (void const *a, void const *b)
{
	int		anum, bnum;

	anum = *(int *)a;
	bnum = *(int *)b;

	anum = game.clients[anum].ps.stats[STAT_FRAGS];
	bnum = game.clients[bnum].ps.stats[STAT_FRAGS];

	if (anum < bnum)
		return -1;
	if (anum > bnum)
		return 1;
	return 0;
}

/*
=================
Cmd_Players_f
=================
*/
void Cmd_Players_f (edict_t *ent)
{
	int		i;
	int		count;
	char	small[64];
	char	large[1280];
	int		index[256];

	count = 0;
	for (i = 0 ; i < maxclients->value ; i++)
		if (game.clients[i].pers.connected)
		{
			index[count] = i;
			count++;
		}

	// sort by frags
	qsort (index, count, sizeof(index[0]), PlayerSort);

	// print information
	large[0] = 0;

	for (i = 0 ; i < count ; i++)
	{
		Com_sprintf (small, sizeof(small), "%3i %s\n",
			game.clients[index[i]].ps.stats[STAT_FRAGS],
			game.clients[index[i]].pers.netname);
		if (strlen (small) + strlen(large) > sizeof(large) - 100 )
		{	// can't print all of them in one packet
			strcat (large, "...\n");
			break;
		}
		strcat (large, small);
	}

	gi.cprintf (ent, PRINT_HIGH, "%s\n%i players\n", large, count);
}

/*
=================
Cmd_Wave_f
=================
*/
void Cmd_Wave_f (edict_t *ent)
{
	int		i;

	if (ent->health<=0)
	{
		//gi.cprintf (ent, PRINT_HIGH, "You must be alive to use this command\n");
		return;
	}

	i = atoi (gi.argv(1));

	// can't wave when ducked
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
		return;

	if (ent->client->anim_priority > ANIM_WAVE)
		return;

	ent->client->anim_priority = ANIM_WAVE;

	switch (i)
	{
	case 0:
		gi.cprintf (ent, PRINT_HIGH, "flipoff\n");
		ent->s.frame = FRAME_flip01-1;
		ent->client->anim_end = FRAME_flip12;
		break;
	case 1:
		gi.cprintf (ent, PRINT_HIGH, "salute\n");
		ent->s.frame = FRAME_salute01-1;
		ent->client->anim_end = FRAME_salute11;
		break;
	case 2:
		gi.cprintf (ent, PRINT_HIGH, "taunt\n");
		ent->s.frame = FRAME_taunt01-1;
		ent->client->anim_end = FRAME_taunt17;
		break;
	case 3:
		gi.cprintf (ent, PRINT_HIGH, "wave\n");
		ent->s.frame = FRAME_wave01-1;
		ent->client->anim_end = FRAME_wave11;
		break;
	case 4:
	default:
		gi.cprintf (ent, PRINT_HIGH, "point\n");
		ent->s.frame = FRAME_point01-1;
		ent->client->anim_end = FRAME_point12;
		break;
	}
}

/*
==================
Cmd_Say_f
==================
*/
qboolean ChatBlocked(edict_t *ent, edict_t *other)
{
	int i=0;
	while (other->blockedChat[i])
	{
		if (other->blockedChat[i]==ent)
			return true;
		i++;
	}
	return false;
}
void Cmd_Say_f (edict_t *ent, qboolean team, qboolean arg0)
{
	int		i, j;
	edict_t	*other;
	char	*p;
	char	text[2048];
	gclient_t *cl;

	if (gi.argc () < 2 && !arg0)
		return;

	if (!((int)(dmflags->value) & (DF_MODELTEAMS | DF_SKINTEAMS))&&!(sv_teams->value&&deathmatch->value))
		team = false;
		
	if ((team)&&!(sv_teams->value&&deathmatch->value))
		Com_sprintf (text, sizeof(text), "(%s)%s ", make_green(ent->client->pers.netname),make_green(":") );
	else if (sv_teams->value&&deathmatch->value)
	{
		char	teamname[12];
		teamname[0] = 0;
		if (ent->TeamName)
		{
			switch (ent->TeamName)
			{
				case 1:
					Com_sprintf (teamname, sizeof(teamname), "Red");
					break;
				case 2:
					Com_sprintf (teamname, sizeof(teamname),"Gold");
					break;		
				case 3:
					Com_sprintf (teamname, sizeof(teamname),"Violet");
					break;	
				case 4:
					Com_sprintf (teamname, sizeof(teamname),"Blue");
					break;
				case 5:
					Com_sprintf (teamname, sizeof(teamname),"Turquoise");
					break;
				case 6:
					Com_sprintf (teamname, sizeof(teamname),"Green");
					break;
				case 7:
					Com_sprintf (teamname, sizeof(teamname),"White");
					break;
				default:
					Com_sprintf (teamname, sizeof(teamname),"Solo");
					break;
			}
		} else
			Com_sprintf (teamname, sizeof(teamname),"Solo");
		
		Com_sprintf (text, sizeof(text), "%s%s%s%s%s%s ", make_green("("), 
			(ent->deadflag == DEAD_DEAD)? "Dead-" : "",
			teamname, make_green(")"), make_green(ent->client->pers.netname),make_green(":") );
	}
	else
		Com_sprintf (text, sizeof(text), "%s%s%s%s%s  ", 
		(ent->deadflag == DEAD_DEAD)? make_green("(") : "",
		(ent->deadflag == DEAD_DEAD)? "Dead" : "",	
		(ent->deadflag == DEAD_DEAD)? make_green(")") : "",
		make_green(ent->client->pers.netname),make_green(":") );

	if (arg0)
	{
		strcat (text, gi.argv(0));
		strcat (text, " ");
		strcat (text, gi.args());
	}
	else
	{
		p = gi.args();

		if (*p == '"')
		{
			p++;
			p[strlen(p)-1] = 0;
		}
		strcat(text, p);
	}

	// don't let text be too long for malicious reasons
	if (strlen(text) > 150)
	
	text[150] = 0;

	strcat(text, "\n");

	for (j = 1; j <= game.maxclients; j++)
	{
		other = &g_edicts[j];
		if (!other->inuse)
			continue;
		if (!other->client)
			continue;
		if (ent->blockedChat)
		{
			if (ChatBlocked(ent, other))
				continue;
		}
		if (team)
		{
			if (!OnSameTeam(ent, other))
				continue;
		}
		if ((ent->deadflag == DEAD_DEAD)&&sv_teams->value&&deathmatch->value)
		{
			if (other->deadflag!=DEAD_DEAD)
				continue;
		}
		
		if (sv_chatdistance->value)
		{
			char	scrambled[2048];
			vec3_t	distance;
			scrambled[0] = 0;

			VectorSubtract (ent->s.origin, other->s.origin, distance);				
			if (!(VectorLength(distance)<sv_chatdistance->value && CanDamage (other, ent))
				|| (ent->health<=0&&other->health>0))
				continue;
		}

		gi.cprintf(other, PRINT_CHAT, "");
		gi.cprintf(other, PRINT_HIGH, "%s", text);

	}
	if (dedicated->value)
		gi.cprintf(NULL, PRINT_CHAT, "%s", make_white(text));
	make_white(ent->client->pers.netname);
}

void Cmd_PlayerList_f(edict_t *ent)
{
	int i;
	char st[80];
	char text[1400];
	edict_t *e2;

	// connect time, ping, headshots/score, name
	*text = 0;
	for (i = 0, e2 = g_edicts + 1; i < maxclients->value; i++, e2++) {
		if (!e2->inuse)
			continue;

		Com_sprintf(st, sizeof(st), "%02d:%02d %4d %3d %s%s\n",
			(level.framenum - e2->client->resp.enterframe) / 600,
			((level.framenum - e2->client->resp.enterframe) % 600)/10,
			e2->client->ping,
			e2->client->resp.score,
			e2->client->pers.netname,
			e2->client->resp.spectator ? " (spectator)" : "");
		if (strlen(text) + strlen(st) > sizeof(text) - 50) {
			sprintf(text+strlen(text), "And more...\n");
			gi.cprintf(ent, PRINT_HIGH, "%s", text);
			return;
		}
		strcat(text, st);
	}
	gi.cprintf(ent, PRINT_HIGH, "%s", text);
}

void Cmd_Info_f (edict_t *ent)
{
	gi.cprintf(ent, PRINT_HIGH, "\n\n-------------------------------\n");
	gi.cprintf(ent, PRINT_HIGH, make_green("PsychoMod Help"));
	gi.cprintf(ent, PRINT_HIGH, "\nListed Below are Binds and Vars\n");
	gi.cprintf(ent, PRINT_HIGH, "-------------------------------\n\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("bind "));
	gi.cprintf(ent, PRINT_HIGH, "\"key\" \"firemode\"\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("bind "));
	gi.cprintf(ent, PRINT_HIGH, "\"key\" \"thirdperson\"\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("bind "));
	gi.cprintf(ent, PRINT_HIGH, "\"key\" \"use grapple\"\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("bind "));
	gi.cprintf(ent, PRINT_HIGH, "\"key\" \"jetpack\"\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("bind "));
	gi.cprintf(ent, PRINT_HIGH, "\"key\" \"+hook\"\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("bind "));
	gi.cprintf(ent, PRINT_HIGH, "\"key\" \"+stunt\"\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("bind "));
	gi.cprintf(ent, PRINT_HIGH, "\"key\" \"+zoom\"\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("bind "));
	gi.cprintf(ent, PRINT_HIGH, "\"key\" \"+use\"\n\n");


	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("ID "));
	gi.cprintf(ent, PRINT_HIGH, "\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("ViewCam "));
	gi.cprintf(ent, PRINT_HIGH, "\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("Block "));
	gi.cprintf(ent, PRINT_HIGH, "\"ClientName\"\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("UnBlock "));
	gi.cprintf(ent, PRINT_HIGH, "\"ClientName\"\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("UnBlock "));
	gi.cprintf(ent, PRINT_HIGH, "\"all\"\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("Team "));
	gi.cprintf(ent, PRINT_HIGH, "\"1-6\"\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("BFGColor "));
	gi.cprintf(ent, PRINT_HIGH, "\"0-2\"\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("GrappleType "));
	gi.cprintf(ent, PRINT_HIGH, "\"0-1\" \"0-1\"\n");
	gi.cprintf(ent, PRINT_HIGH, "\n-------------------------------\n\n");
}

void Cmd_InfoSV_f (edict_t *ent)
{

	gi.cprintf(ent, PRINT_HIGH, "\n\n-------------------------------\n");
	gi.cprintf(ent, PRINT_HIGH, make_green("PsychoMod Server Help"));
	gi.cprintf(ent, PRINT_HIGH, "\nListed Below are Server Cmds\n");
	gi.cprintf(ent, PRINT_HIGH, "-------------------------------\n\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("sv cheats "));
	gi.cprintf(ent, PRINT_HIGH, "\"0 or 1\"\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("sv teams "));
	gi.cprintf(ent, PRINT_HIGH, "\"0 or 1 or 'lock' or 'unlock'\"\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("sv tracers "));
	gi.cprintf(ent, PRINT_HIGH, "\"amount\"\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("sv bulletmarks "));
	gi.cprintf(ent, PRINT_HIGH, "\"amount\"\n");
	gi.cprintf(ent, PRINT_HIGH, " > ");
	gi.cprintf(ent, PRINT_HIGH, make_green("sv spawn "));
	gi.cprintf(ent, PRINT_HIGH, "\"monster name\"\n");
	gi.cprintf(ent, PRINT_HIGH, "\n-------------------------------\n\n");
}

void Cmd_BFG_Color_f (edict_t *ent)
{
	char		*name;


	name = gi.args();

	if ((Q_stricmp(name, "red") == 0) || (Q_stricmp(name, "1") == 0))
	{
		ent->bfg_laser_type=BFG_LASER_RED;
		if (ent->configed)
			gi.cprintf(ent, PRINT_HIGH, "\n- Red BFG Laser -\n\n");
	}
	else if  ((Q_stricmp(name, "blue") == 0) || (Q_stricmp(name, "0") == 0))
	{
		ent->bfg_laser_type=BFG_LASER_BLUE;
		if (ent->configed)
			gi.cprintf(ent, PRINT_HIGH, "\n- Blue BFG Laser -\n\n");
	}
	else
	{
		ent->bfg_laser_type=BFG_LASER_GREEN;
		if (ent->configed)
			gi.cprintf(ent, PRINT_HIGH, "\n- Green BFG Laser -\n\n");
	}
}

void Cmd_Grapple_Type_f (edict_t *ent)
{
	char		*name, *name2;
	name = gi.argv(2);
	name2 = gi.argv(1);

	if (gi.argc() >= 2)
	{
		gi.cprintf(ent, PRINT_HIGH, "\n");
		if (Q_stricmp(name2, "1") == 0)
		{
			ent->grappleType=GRAPPLE_LASER;
			if (ent->configed)
				gi.cprintf(ent, PRINT_HIGH, "- Laser Type - ");
		}
	/*	else if (Q_stricmp(name2, "2") == 0) // Lag Maker...
		{
			ent->grappleType=GRAPPLE_CHAIN;
			gi.cprintf(ent, PRINT_HIGH, "- Chain Type - ");
		}*/
		else if (Q_stricmp(name2, "100") == 0)
		{
			ent->grappleType=GRAPPLE_SHIP1;
			if (ent->configed)
				gi.cprintf(ent, PRINT_HIGH, "- Strogg Type - ");
		}
		else if (Q_stricmp(name2, "101") == 0)
		{
			ent->grappleType=GRAPPLE_SHIP2;
			if (ent->configed)
				gi.cprintf(ent, PRINT_HIGH, "- Viper Type - ");
		}
		else
		{
			ent->grappleType=GRAPPLE_ROPE;
			if (ent->configed)
				gi.cprintf(ent, PRINT_HIGH, "- Rope Type - ");
		}
		
		if (gi.argc() >= 3)
		{
			if (Q_stricmp(name, "2") == 0)
			{
				ent->grapple=ROPE_GRAPPLE;
				if (ent->configed)
					gi.cprintf(ent, PRINT_HIGH, "Rope Grapple -\n");
			}
			else if (Q_stricmp(name, "1") == 0)
			{
				ent->grapple=LITHIUM_GRAPPLE;
				if (ent->configed)
					gi.cprintf(ent, PRINT_HIGH, "Lithium Grapple -\n");
			}
			else
			{
				ent->grapple=PSYCHOMOD_GRAPPLE;
				if (ent->configed)
					gi.cprintf(ent, PRINT_HIGH, "Psychomod Grapple -\n");
			}
		}
		else if (ent->configed)
			gi.cprintf(ent, PRINT_HIGH, "\n");

		if (ent->configed)
			gi.cprintf(ent, PRINT_HIGH, "\n");
	}
	else if (ent->configed)
		gi.cprintf(ent, PRINT_HIGH, "Invalid Arguments\n");


	//	ent->client->pers.inventory[index] = atoi(gi.argv(2));
	/*
	#define ROPE 2
	#define LITHIUM 1
	#define PSYCHOMOD 0
	*/
}

void Cmd_ViewCam_Type_f (edict_t *ent)
{
	if (ent->viewcam_on)
		ent->viewcam_on = 0;
	else if (ent->viewcam_on==0)
		ent->viewcam_on = 1;
	
	gi.cprintf(ent, PRINT_HIGH, "View Cam %s\n", (ent->viewcam_on==0)? "OFF" : "ON");
}

void Cmd_ID_f (edict_t *ent)
{
	if (ent->Player_ID)
	{
		ent->Player_ID= 0;
		if (ent->configed)
			gi.cprintf(ent, PRINT_HIGH, "Client ID Off\n");
	}
	else
	{
		ent->Player_ID=1;
		if (ent->configed)
			gi.cprintf(ent, PRINT_HIGH, "Client ID On\n");
	}
}

void Cmd_Team_f (edict_t *ent)
{
	if (sv_teams_locked->value)
	{
		gi.cprintf(ent, PRINT_HIGH, "Teams are Locked.\n", ent->TeamName);
		return;
	}
	
	if (gi.argc() > 1)
	{
		if ( atoi(gi.argv(1))>=0 && atoi(gi.argv(1))<=7 ) 
		{
			ent->TeamName=atoi (gi.argv(1));
			switch (ent->TeamName)
			{
				case 1:
					gi.cprintf(ent, PRINT_HIGH, "You have now joined the \"%s\" team.\n", 
							make_white("Red"));
					break;
				case 2:
					gi.cprintf(ent, PRINT_HIGH, "You have now joined the \"%s\" team.\n", 
							make_white("Gold"));
					break;		
				case 3:
					gi.cprintf(ent, PRINT_HIGH, "You have now joined the \"%s\" team.\n", 
							make_white("Violet"));
					break;	
				case 4:
					gi.cprintf(ent, PRINT_HIGH, "You have now joined the \"%s\" team.\n", 
							make_white("Blue"));
					break;
				case 5:
					gi.cprintf(ent, PRINT_HIGH, "You have now joined the \"%s\" team.\n", 
							make_white("Turquoise"));
					break;
				case 6:
					gi.cprintf(ent, PRINT_HIGH, "You have now joined the \"%s\" team.\n", 
							make_white("Green"));
					break;
				case 7:
					gi.cprintf(ent, PRINT_HIGH, "You have now joined the \"%s\" team.\n", 
							make_white("White"));
					break;
				case 0:
					gi.cprintf(ent, PRINT_HIGH, "You have now joined the \"%s\" team.\n", 
							make_white("Solo"));
					break;
			}
		}
		else
			gi.cprintf(ent, PRINT_HIGH, "Invalid Arguments\n");
	}
	else
		switch (ent->TeamName)
			{
				case 1:
					gi.cprintf(ent, PRINT_HIGH, "You are on the \"%s\" team.\n", 
							make_white("Red"));
					break;
				case 2:
					gi.cprintf(ent, PRINT_HIGH, "You are on the \"%s\" team.\n", 
							make_white("Gold"));
					break;		
				case 3:
					gi.cprintf(ent, PRINT_HIGH, "You are on the \"%s\" team.\n", 
							make_white("Violet"));
					break;	
				case 4:
					gi.cprintf(ent, PRINT_HIGH, "You are on the \"%s\" team.\n", 
							make_white("Blue"));
					break;
				case 5:
					gi.cprintf(ent, PRINT_HIGH, "You are on the \"%s\" team.\n", 
							make_white("Turquoise"));
					break;
				case 6:
					gi.cprintf(ent, PRINT_HIGH, "You are on the \"%s\" team.\n", 
							make_white("Green"));
					break;
				case 7:
					gi.cprintf(ent, PRINT_HIGH, "You are on the \"%s\" team.\n", 
							make_white("White"));
					break;
				case 0:
					gi.cprintf(ent, PRINT_HIGH, "You are on the \"%s\" team.\n", 
							make_white("Solo"));
					break;
			}
}

void Cmd_UnBlockChat_f (edict_t *ent)
{
	edict_t *other;
	int j, i=0;
	
	if (gi.argc()<=1)
	{
		gi.cprintf(ent, PRINT_HIGH, make_green("-------------------------"));
		gi.cprintf(ent, PRINT_HIGH, "\n");
		gi.cprintf(ent, PRINT_HIGH, make_green("Blocked Clients"));
		gi.cprintf(ent, PRINT_HIGH, "\n");
		gi.cprintf(ent, PRINT_HIGH, make_green("-------------------------"));
		gi.cprintf(ent, PRINT_HIGH, "\n");
		while (ent->blockedChat[i])
		{
			if (ent->blockedChat[i])
				gi.cprintf(ent, PRINT_HIGH, "%s\n", ent->blockedChat[i]->client->pers.netname);
			i++;
		}
		if (i==0)
			gi.cprintf(ent, PRINT_HIGH, "No Clients Blocked\n");
		gi.cprintf(ent, PRINT_HIGH, make_green("-------------------------"));
		gi.cprintf(ent, PRINT_HIGH, "\n");
		return;
	}

	if (!Q_stricmp(gi.argv(1), "all"))
	{
		while (ent->blockedChat[i])
		{
			gi.cprintf(ent->blockedChat[i], PRINT_HIGH, "%s has UnBlocked your chat.\n", ent->client->pers.netname);
			ent->blockedChat[i]=NULL;
			i++;
		}

		gi.cprintf(ent, PRINT_HIGH, "All Clients UnBlocked\n");
		return;
	}

	for (j = 1; j <= game.maxclients; j++)
	{
		other = &g_edicts[j];
		if (!other->client)
			continue;
		if (!Q_stricmp(gi.argv(1), make_white(other->client->pers.netname)))
		{
			ent->blockedChat[i]=other;
			gi.cprintf(other, PRINT_HIGH, "%s has UnBlocked your chat.\n", ent->client->pers.netname);
			gi.cprintf(ent, PRINT_HIGH, "Client \"%s\" UnBlocked\n", other->client->pers.netname);
			while (ent->blockedChat[i])
			{
				ent->blockedChat[i]=ent->blockedChat[i+1];
					i++;
			}
			ent->blockedChat[i]=NULL;
			return;
		}
	}
	gi.cprintf(ent, PRINT_HIGH, "No Client UnBlocked\n");	
}

void Cmd_BlockChat_f (edict_t *ent)
{
	edict_t *other;
	int j, i=0;
	
	if (gi.argc()<=1)
	{
		gi.cprintf(ent, PRINT_HIGH, make_green("-------------------------"));
		gi.cprintf(ent, PRINT_HIGH, "\n");
		gi.cprintf(ent, PRINT_HIGH, make_green("Clients"));
		gi.cprintf(ent, PRINT_HIGH, "\n");
		gi.cprintf(ent, PRINT_HIGH, make_green("-------------------------"));
		gi.cprintf(ent, PRINT_HIGH, "\n");
		for (j = 1; j <= game.maxclients; j++)
		{
			other = &g_edicts[j];
			if (!other->client)
				continue;
			if (Q_stricmp("", make_white(other->client->pers.netname)))
			{
				gi.cprintf(ent, PRINT_HIGH, "%s\n", other->client->pers.netname);	
			}
		}
		gi.cprintf(ent, PRINT_HIGH, make_green("-------------------------"));
		gi.cprintf(ent, PRINT_HIGH, "\n");
		return;
	}

	while (ent->blockedChat[i])
	{
		if (ent->blockedChat[i])
			i++;
	}
	
	for (j = 1; j <= game.maxclients; j++)
	{
		other = &g_edicts[j];
		if (!other->client)
			continue;
		if (!Q_stricmp(gi.argv(1), make_white(other->client->pers.netname)))
		{
			ent->blockedChat[i]=other;
			gi.cprintf(ent, PRINT_HIGH, "%s Blocked\n", other->client->pers.netname);
			gi.cprintf(other, PRINT_HIGH, "%s has Blocked your chat.\n", ent->client->pers.netname);
			return;
		}
	}
	gi.cprintf(ent, PRINT_HIGH, "No Client Blocked\n");	
}

/*
=================
ClientCommand
=================
*/
void ClientCommand (edict_t *ent)
{
	char	*cmd;

	if (!ent->client)
		return;		// not fully in game yet

	cmd = gi.argv(0);

	if (Q_stricmp (cmd, "players") == 0)
	{
		Cmd_Players_f (ent);
		return;
	}
	if (Q_stricmp (cmd, "say") == 0)
	{
		Cmd_Say_f (ent, false, false);
		return;
	}
	if (Q_stricmp (cmd, "say_team") == 0)
	{
		Cmd_Say_f (ent, true, false);
		return;
	}

	//MY COMMANDS
	if (Q_stricmp(cmd, "bfgcolor") == 0)
	{
		Cmd_BFG_Color_f(ent);
		return;
	}
	if (Q_stricmp(cmd, "grappletype") == 0)
	{
		Cmd_Grapple_Type_f(ent);
		return;
	}
	if (Q_stricmp(cmd, "helpme") == 0)
	{
		Cmd_Info_f(ent);
		return;
	}
	if (Q_stricmp(cmd, "helpsv") == 0)
	{
		Cmd_InfoSV_f(ent);
		return;
	}
	if (Q_stricmp (cmd, "id") == 0)
	{
		Cmd_ID_f (ent);
		return;
	}
	if (Q_stricmp (cmd, "viewcam") == 0)
	{
		Cmd_ViewCam_Type_f (ent);
		return;
	}
	if (Q_stricmp(cmd, "stunton") == 0)
	{
		ent->client->stunt=true;
		CheckStunt (ent);
		return;
	}
	if (Q_stricmp (cmd, "stuntoff") == 0)
	{
		ent->client->stunt=false;
		return;
	}

	if ( (level.framenum-ent->client->resp.enterframe)/10 < ent->client->MotdTime)
	{
		if ((Q_stricmp (cmd, "score") == 0)||(Q_stricmp (cmd, "help") == 0))
		{
			ent->client->showinventory = false;
			ent->client->showscores = false;
			ent->client->showhelp = false;
			ent->client->ps.stats[STAT_LAYOUTS] = 0;
			ent->client->MotdTime = 0;
			return;
		}
	}
	if (Q_stricmp (cmd, "score") == 0)
	{
		Cmd_Score_f (ent);
		return;
	}
	if (Q_stricmp (cmd, "help") == 0)
	{
		Cmd_Help_f (ent);
		return;
	}

	if (level.intermissiontime)
		return;

	if (Q_stricmp (cmd, "use") == 0)
		Cmd_Use_f (ent);
	else if (Q_stricmp (cmd, "drop") == 0)
		Cmd_Drop_f (ent);

	else if (Q_stricmp(cmd, "alt_fire") == 0)
		Cmd_Alt_Mode_f(ent);
	else if (Q_stricmp(cmd, "attack2") == 0)
		Cmd_Alt_Mode_f(ent);
	else if (Q_stricmp(cmd, "firemode") == 0)
		Cmd_Alt_Mode_f(ent);

	else if (Q_stricmp (cmd, "team") == 0)
		Cmd_Team_f (ent);

	else if (Q_stricmp (cmd, "Block") == 0)
		Cmd_BlockChat_f (ent);
	else if (Q_stricmp (cmd, "UnBlock") == 0)
		Cmd_UnBlockChat_f (ent);

//############ **** CHEATS **** ############

	else if (Q_stricmp (cmd, "give") == 0 && sv_cheats->value)
		Cmd_Give_f (ent);
	else if (Q_stricmp (cmd, "god") == 0 && sv_cheats->value)
		Cmd_God_f (ent);
	else if (Q_stricmp (cmd, "notarget") == 0 && sv_cheats->value)
		Cmd_Notarget_f (ent);
	else if (Q_stricmp (cmd, "noclip") == 0 && sv_cheats->value)
		Cmd_Noclip_f (ent);	
/*
	else if (Q_stricmp (cmd, "give") == 0 && !sv_cheats->value)
		Cmd_Notify_Cheat (ent);
	else if (Q_stricmp (cmd, "god") == 0 && !sv_cheats->value)
		Cmd_Notify_Cheat (ent);
	else if (Q_stricmp (cmd, "notarget") == 0 && !sv_cheats->value)
		Cmd_Notify_Cheat (ent);
	else if (Q_stricmp (cmd, "noclip") == 0 && !sv_cheats->value)
		Cmd_Notify_Cheat (ent);	
*/
//############ **** CHEATS **** ############

	else if (Q_stricmp (cmd, "inven") == 0)
		Cmd_Inven_f (ent);
	else if (Q_stricmp (cmd, "invnext") == 0)
		SelectNextItem (ent, -1);
	else if (Q_stricmp (cmd, "invprev") == 0)
		SelectPrevItem (ent, -1);
	else if (Q_stricmp (cmd, "invnextw") == 0)
		SelectNextItem (ent, IT_WEAPON);
	else if (Q_stricmp (cmd, "invprevw") == 0)
		SelectPrevItem (ent, IT_WEAPON);
	else if (Q_stricmp (cmd, "invnextp") == 0)
		SelectNextItem (ent, IT_POWERUP);
	else if (Q_stricmp (cmd, "invprevp") == 0)
		SelectPrevItem (ent, IT_POWERUP);
	else if (Q_stricmp (cmd, "invuse") == 0)
		Cmd_InvUse_f (ent);
	else if (Q_stricmp (cmd, "weapdrop") == 0)
		Cmd_WeapDrop_f (ent);
	else if (Q_stricmp (cmd, "invdrop") == 0)
		Cmd_InvDrop_f (ent);
	else if (Q_stricmp (cmd, "weapprev") == 0)
		Cmd_WeapPrev_f (ent);
	else if (Q_stricmp (cmd, "weapnext") == 0)
		Cmd_WeapNext_f (ent);
	else if (Q_stricmp (cmd, "weaplast") == 0)
		Cmd_WeapLast_f (ent);
	else if (Q_stricmp (cmd, "kill") == 0)
		Cmd_Kill_f (ent);
	else if (Q_stricmp (cmd, "putaway") == 0)
		Cmd_PutAway_f (ent);
	else if (Q_stricmp (cmd, "wave") == 0)
		Cmd_Wave_f (ent);
	else if (Q_stricmp(cmd, "playerlist") == 0)
		Cmd_PlayerList_f(ent);
	else if (Q_stricmp(cmd, "listplayers") == 0)
		Cmd_PlayerList_f(ent);
	else if (Q_stricmp(cmd, "setspot") == 0)
	{
		VectorCopy (ent->s.origin, nextmonsterspawn);
		VectorCopy (ent->s.angles, nextmonsterspawnangles);
	}
	else if (Q_stricmp (cmd, "thirdperson") == 0 && (deathmatch->value || coop->value || sv_cheats->value))
		Cmd_Chasecam_Toggle (ent);
	else	// anything that doesn't match a command will be a chat
		Cmd_Say_f (ent, false, true);
}
