/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include "../client/client.h"
#include "../client/qmenu.h"

extern cvar_t *vid_ref;
extern cvar_t *vid_fullscreen;
extern cvar_t *vid_gamma;
extern cvar_t *scr_viewsize;

cvar_t	*r_overbrightbits;
cvar_t	*r_celshading;

static cvar_t *video_menu;
static cvar_t *gl_mode;
static cvar_t *gl_driver;
static cvar_t *gl_picmip;
static cvar_t *gl_texturemode;
static cvar_t *gl_anisotropic;
static cvar_t *gl_swapinterval;
static cvar_t *con_font_size;

extern void M_ForceMenuOff( void );

float scaledVideo (float param);
float videoScale (void);

/*
====================================================================

MENU INTERACTION

====================================================================
*/

static menuframework_s	s_opengl_menu;

static menuframework_s	s_opengl_system_menu;
static menuframework_s	s_opengl_advanced_menu;
static menuframework_s	s_opengl_misc_menu;

static menuaction_s		s_vid_system_section;
static menuaction_s		s_vid_advanced_section;
static menuaction_s		s_vid_misc_section;

static menulist_s		s_mode_list;
static menulist_s		s_texqual_box;
static menuslider_s		s_screensize_slider;
static menuslider_s		s_brightness_slider;
static menulist_s		s_tfilter_box;
static menulist_s  		s_fs_box;
static menulist_s  		s_vsync_box;
static menulist_s		s_refresh_box;	// Knightmare- refresh rate option
static menulist_s  		s_adjust_fov_box;		// Knightmare- widesreen fov option

//static menulist_s  		s_texcompress_box;
static menulist_s		s_aniso_box;	// Knightmare- anisotropic filter option
static menulist_s  		s_npot_mipmap_box;	// Knightmare- non-power-of-2 texture option

static menufield_s		s_particle_field;
static menufield_s		s_decal_field;
static menulist_s  		s_overbrights_box;
static menulist_s  		s_shaders_box;
static menulist_s  		s_celshading_box;
static menulist_s  		s_transsort_box;
static menulist_s  		s_glares_box;
static menulist_s  		s_skyglares_box;
static menulist_s  		s_shellglares_box;

static menulist_s  		s_shadows_box;
static menulist_s  		s_fps_box;
static menulist_s  		s_netgraph_box;
static menulist_s  		s_netgpos_box;

static menuaction_s		s_apply_action;
static menuaction_s		s_defaults_action;


static menuaction_s		s_back_action;


static float ClampCvar( float min, float max, float value )
{
	if ( value < min ) return min;
	if ( value > max ) return max;
	return value;
}

static void ScreenSizeCallback( void *s )
{
	menuslider_s *slider = ( menuslider_s * ) s;

	Cvar_SetValue( "viewsize", slider->curvalue * 10 );
}

static void BrightnessCallback( void *s )
{
	menuslider_s *slider = ( menuslider_s * ) s;

	Cvar_SetValue( "vid_gamma", ( 0.8 - ( s_brightness_slider.curvalue/10.0 - 0.5 ) ) + 0.5 );
}

// Knightmare added
static void VsyncCallback ( void *unused )
{
	Cvar_SetValue( "gl_swapinterval", s_vsync_box.curvalue);
}

static void AdjustFOVCallback ( void *unused )
{
	Cvar_SetValue( "cl_widescreen_fov", s_adjust_fov_box.curvalue);
}
// end Knightmare

// Knightmare- callback for texture mode
static void TexFilterCallback( void *s )
{
	if (s_tfilter_box.curvalue == 0)
		Cvar_Set("gl_texturemode", "GL_NEAREST");
	else if (s_tfilter_box.curvalue == 1)
		Cvar_Set("gl_texturemode", "GL_NEAREST_MIPMAP_NEAREST");
	else if (s_tfilter_box.curvalue == 2)
		Cvar_Set("gl_texturemode", "GL_LINEAR");
	else if (s_tfilter_box.curvalue == 3)
		Cvar_Set("gl_texturemode", "GL_LINEAR_MIPMAP_NEAREST");
	else if (s_tfilter_box.curvalue == 4)
		Cvar_Set("gl_texturemode", "GL_LINEAR_MIPMAP_LINEAR");
}

// Knightmare- anisotropic filtering
static void AnisoCallback( void *s )
{
	switch ((int)s_aniso_box.curvalue)
	{
		case 1: Cvar_SetValue ("gl_anisotropic", 2.0); break;
		case 2: Cvar_SetValue ("gl_anisotropic", 4.0); break;
		case 3: Cvar_SetValue ("gl_anisotropic", 8.0); break;
		case 4: Cvar_SetValue ("gl_anisotropic", 16.0); break;
		default:
		case 0: Cvar_SetValue ("gl_anisotropic", 0.0); break;
	}
}

static void ResetDefaults( void *unused )
{
	VID_MenuInit();
}

static void prepareVideoRefresh( void )
{
	//set the right mode for refresh
	Cvar_Set( "vid_ref", "gl" );
	Cvar_Set( "gl_driver", "opengl32" );

	//tell them theyr're modified so they refresh
	if ( vid_gamma->modified )
		vid_ref->modified = true;
	if ( gl_driver->modified )
		vid_ref->modified = true;
}

static void ApplyChanges( void *unused )
{
	int		temp;	// Knightmare added

	/*
	** invert sense so greater = brighter, and scale to a range of 0.5 to 1.3
	*/

/*
	if (s_tfilter_box.curvalue == 0)
		Cvar_Set("gl_texturemode", "GL_NEAREST");
	else if (s_tfilter_box.curvalue == 1)
		Cvar_Set("gl_texturemode", "GL_NEAREST_MIPMAP_NEAREST");
	else if (s_tfilter_box.curvalue == 2)
		Cvar_Set("gl_texturemode", "GL_LINEAR");
	else if (s_tfilter_box.curvalue == 3)
		Cvar_Set("gl_texturemode", "GL_LINEAR_MIPMAP_NEAREST");
	else if (s_tfilter_box.curvalue == 4)
		Cvar_Set("gl_texturemode", "GL_LINEAR_MIPMAP_LINEAR");
	else if (s_tfilter_box.curvalue == 5)
		Cvar_Set("gl_texturemode", "GL_LINEAR_MIPMAP_NEAREST");
	else //if (s_tfilter_box.curvalue == 6)
		Cvar_Set("gl_texturemode", "GL_LINEAR_MIPMAP_LINEAR");
*/

//	Cvar_SetValue( "gl_anisotropic", (s_tfilter_box.curvalue > 4) );
	Cvar_SetValue( "gl_picmip", 3-s_texqual_box.curvalue );
	Cvar_SetValue( "vid_fullscreen", s_fs_box.curvalue );
	Cvar_SetValue( "gl_swapinterval", s_vsync_box.curvalue );
	// Knightmare- widesreen fov option
	Cvar_SetValue( "cl_widescreen_fov", s_adjust_fov_box.curvalue );

	// Knightmare- refesh rate option
	switch (s_refresh_box.curvalue)
	{
	case 10:
		Cvar_SetValue ("gl_displayrefresh", 150);
		break;
	case 9:
		Cvar_SetValue ("gl_displayrefresh", 144);
		break;
	case 8:
		Cvar_SetValue ("gl_displayrefresh", 120);
		break;
	case 7:
		Cvar_SetValue ("gl_displayrefresh", 110);
		break;
	case 6:
		Cvar_SetValue ("gl_displayrefresh", 100);
		break;
	case 5:
		Cvar_SetValue ("gl_displayrefresh", 85);
		break;
	case 4:
		Cvar_SetValue ("gl_displayrefresh", 75);
		break;
	case 3:
		Cvar_SetValue ("gl_displayrefresh", 72);
		break;
	case 2:
		Cvar_SetValue ("gl_displayrefresh", 70);
		break;
	case 1:
		Cvar_SetValue ("gl_displayrefresh", 60);
		break;
	case 0:
	default:
		Cvar_SetValue ("gl_displayrefresh", 0);
		break;
	}

//	Cvar_SetValue( "gl_mode", s_mode_list.curvalue );
	temp = s_mode_list.curvalue;
	Cvar_SetValue ("gl_mode", (temp == 0) ? -1 : temp + 2);	// Knightmare- use offset of 2 because of hidden modes

//	Cvar_SetValue( "gl_ext_texture_compression", s_texcompress_box.curvalue );

	// Knightmare- non-power-of-2 texture option
	Cvar_SetValue ("gl_nonpoweroftwo_mipmaps", s_npot_mipmap_box.curvalue);

	// Knightmare- anisotropic filtering
	switch ((int)s_aniso_box.curvalue)
	{
		case 1: Cvar_SetValue ("gl_anisotropic", 2.0); break;
		case 2: Cvar_SetValue ("gl_anisotropic", 4.0); break;
		case 3: Cvar_SetValue ("gl_anisotropic", 8.0); break;
		case 4: Cvar_SetValue ("gl_anisotropic", 16.0); break;
		default:
		case 0: Cvar_SetValue ("gl_anisotropic", 0.0); break;
	}

	Cvar_SetValue( "r_shaders", s_shaders_box.curvalue );
	Cvar_SetValue( "r_celshading", s_celshading_box.curvalue );
	Cvar_SetValue( "gl_transrendersort", s_transsort_box.curvalue );
	if (s_overbrights_box.curvalue)
		Cvar_SetValue( "r_overbrightbits", (int)(s_overbrights_box.curvalue)<<1 );
	else
		Cvar_SetValue( "r_overbrightbits", 0 );
	Cvar_SetValue( "r_particles", atoi( s_particle_field.buffer) );
	Cvar_SetValue( "r_decals", atoi( s_decal_field.buffer) );
	Cvar_SetValue( "rs_glares", s_glares_box.curvalue );
	Cvar_SetValue( "rs_glares_sky", s_skyglares_box.curvalue );

	if (s_glares_box.curvalue == 0)
		Cvar_SetValue( "rs_glares", 0 );
	else if (s_glares_box.curvalue ==1)
		Cvar_SetValue( "rs_glares", 1 );
	else if (s_glares_box.curvalue ==2)
		Cvar_SetValue( "rs_glares", 1.5 );
	else
		Cvar_SetValue( "rs_glares", 3 );

	Cvar_SetValue( "gl_shadows", s_shadows_box.curvalue );
	Cvar_SetValue( "cl_drawfps", s_fps_box.curvalue );
	Cvar_SetValue( "netgraph", s_netgraph_box.curvalue );
	Cvar_SetValue( "netgraph_pos", s_netgpos_box.curvalue );

	prepareVideoRefresh ();

	M_ForceMenuOff();
}

static void CancelChanges( void *unused )
{
	extern void M_PopMenu( void );

	M_PopMenu();
}



static void setMenuSystem ( void *unused )
{
	Cvar_SetValue( "video_menu", 0 );
	refreshCursorLink();
}
static void setMenuAdvanced ( void *unused )
{
	Cvar_SetValue( "video_menu", 1 );
	refreshCursorLink();
}
static void setMenuMiscellaneous ( void *unused )
{
	Cvar_SetValue( "video_menu", 2 );
	refreshCursorLink();
}

// Knightmare- texture filter mode
int texfilter_box_setval (void)
{
	if (!Q_strcasecmp(gl_texturemode->string, "GL_NEAREST"))
		return 0;
	else if (!Q_strcasecmp(gl_texturemode->string, "GL_NEAREST_MIPMAP_NEAREST"))
		return 1;
	else if (!Q_strcasecmp(gl_texturemode->string, "GL_LINEAR"))
		return 2;
	else if (!Q_strcasecmp(gl_texturemode->string, "GL_LINEAR_MIPMAP_NEAREST"))
	//	return (gl_anisotropic->value)? 5 :3;
		return 3;
	else // if (!Q_strcasecmp(gl_texturemode->string, "GL_LINEAR_MIPMAP_LINEAR"))
	//	return (gl_anisotropic->value)? 6 :4;
		return 4;
}

// Knightmare- refresh rate option
int refresh_box_setval (void)
{
	int refreshVar = (int)Cvar_VariableValue ("gl_displayrefresh");

	if (refreshVar == 150)
		return 10;
	else if (refreshVar == 144)
		return 9;
	else if (refreshVar == 120)
		return 8;
	else if (refreshVar == 110)
		return 7;
	else if (refreshVar == 100)
		return 6;
	else if (refreshVar == 85)
		return 5;
	else if (refreshVar == 75)
		return 4;
	else if (refreshVar == 72)
		return 3;
	else if (refreshVar == 70)
		return 2;
	else if (refreshVar == 60)
		return 1;
	else
		return 0;
}

// Knightmare- anisotropic filtering
static const char *aniso0_names[] =
{
	"not supported",
	0
};

static const char *aniso2_names[] =
{
	"off",
	"2x",
	0
};

static const char *aniso4_names[] =
{
	"off",
	"2x",
	"4x",
	0
};

static const char *aniso8_names[] =
{
	"off",
	"2x",
	"4x",
	"8x",
	0
};

static const char *aniso16_names[] =
{
	"off",
	"2x",
	"4x",
	"8x",
	"16x",
	0
};

static const char **GetAnisoNames ()
{
	float aniso_avail = Cvar_VariableValue("gl_anisotropic_avail");
	if (aniso_avail < 2.0)
		return aniso0_names;
	else if (aniso_avail < 4.0)
		return aniso2_names;
	else if (aniso_avail < 8.0)
		return aniso4_names;
	else if (aniso_avail < 16.0)
		return aniso8_names;
	else // >= 16.0
		return aniso16_names;
}

float GetAnisoCurValue ()
{
	float aniso_avail = Cvar_VariableValue("gl_anisotropic_avail");
	float anisoValue = ClampCvar (0, aniso_avail, Cvar_VariableValue("gl_anisotropic"));
	if (aniso_avail == 0) // not available
		return 0;
	if (anisoValue < 2.0)
		return 0;
	else if (anisoValue < 4.0)
		return 1;
	else if (anisoValue < 8.0)
		return 2;
	else if (anisoValue < 16.0)
		return 3;
	else // >= 16.0
		return 4;
}
// end Knightmare

/*
** VID_MenuInit
*/
void VID_MenuInit( void )
{
	// Knightmare- use resolution list from header
	static const char *resolutions[] = 
	{
#include "../qcommon/vid_resolutions.h"
	};
/*	static const char *resolutions[] = 
	{
		"[320 240  ]",
		"[400 300  ]",
		"[512 384  ]",
		"[640 480  ]",
		"[800 600  ]",
		"[960 720  ]",
		"[1024 768 ]",
		"[1152 864 ]",
		"[1280 960 ]",
		"[1600 1200]",
		"[2048 1536]",
		0
	};	*/
	static const char *refreshrate_names[] = 
	{
		"[default]",
		"[60Hz   ]",
		"[70Hz   ]",
		"[72Hz   ]",
		"[75Hz   ]",
		"[85Hz   ]",
		"[100Hz  ]",
		"[110Hz  ]",
		"[120Hz  ]",
		"[144Hz  ]",
		"[150Hz  ]",
		0
	};
	static const char *yesno_names[] =
	{
		"no",
		"yes",
		0
	};
	static const char *texfilter_names[] =
	{
		"none",
		"nearest",
		"linear",
		"bilinear",
		"trilinear",
	//	"bilinear anisotropic",
	//	"trilinear anisotopic",		
		0
	};
	static const char *lmh_names[] =
	{
		"low",
		"medium",
		"high",
		"highest",
		0
	};
	static const char *sort_names[] =
	{
		"off",
		"by depth",
		"by depth w/ surfaces",
		0
	};
	static const char *overbright_names[] =
	{
		"off",
		"low",
		"high",
		0
	};
	static const char *glares_names[] =
	{
		"off",
		"low",
		"medium",
		"high",
		0
	};
	static const char *shadow_names[] =
	{
		"off",
		"static",
		"projected",
		0
	};
	static const char *netgraph_names[] =
	{
		"bottom right",
		"bottom left",
		"top right",
		"top left",
		0
	};
	float	temp;	// Knghtmare added

	if (!video_menu)
		video_menu = Cvar_Get ("video_menu", "0", 0);

	if ( !gl_driver )
		gl_driver = Cvar_Get( "gl_driver", "opengl32", 0 );
	if ( !gl_picmip )
		gl_picmip = Cvar_Get( "gl_picmip", "0", 0 );
	if ( !gl_mode )
		gl_mode = Cvar_Get( "gl_mode", "0", 0 );
	if ( !gl_swapinterval )
		gl_swapinterval = Cvar_Get( "gl_swapinterval", "0", CVAR_ARCHIVE );
	if ( !gl_texturemode )
		gl_texturemode = Cvar_Get( "gl_texturemode", "GL_LINEAR_MIPMAP_NEAREST", CVAR_ARCHIVE );
	if ( !gl_anisotropic )
		gl_anisotropic = Cvar_Get( "gl_anisotropic", "0", CVAR_ARCHIVE );
	if ( !r_overbrightbits )
		r_overbrightbits = Cvar_Get( "r_overbrightbits", "2", CVAR_ARCHIVE );


//	s_mode_list.curvalue = gl_mode->value;
	temp = Cvar_VariableValue("gl_mode");
	s_mode_list.curvalue = (temp == -1) ? 0 : max(temp - 2, 1);	// Knightmare- use offset of 2 because of hidden modes

	if ( !scr_viewsize )
		scr_viewsize = Cvar_Get ("viewsize", "100", CVAR_ARCHIVE);

	if ( !con_font_size )
		con_font_size = Cvar_Get ("con_font_size", "8", CVAR_ARCHIVE);

	s_screensize_slider.curvalue = scr_viewsize->value/10;

	s_opengl_menu.x = viddef.width/2;
	s_opengl_menu.y = viddef.height/2 - scaledVideo(58);
	s_opengl_menu.nitems = 0;
	s_opengl_system_menu.x = s_opengl_menu.x;
	s_opengl_system_menu.y = s_opengl_menu.y;
	s_opengl_system_menu.nitems = 0;
	s_opengl_advanced_menu.x = s_opengl_menu.x;
	s_opengl_advanced_menu.y = s_opengl_menu.y;
	s_opengl_advanced_menu.nitems = 0;
	s_opengl_misc_menu.x = s_opengl_menu.x;
	s_opengl_misc_menu.y = s_opengl_menu.y;
	s_opengl_misc_menu.nitems = 0;

	//SECTION SELECTORS
	{
		s_vid_system_section.generic.type				= MTYPE_ACTION;
		s_vid_system_section.generic.name				= "system";
		s_vid_system_section.generic.x					= -MENU_FONT_SIZE * 10;
		s_vid_system_section.generic.y					= 0;
		s_vid_system_section.generic.callback			= setMenuSystem;
		s_vid_system_section.generic.cursor_offset		= s_vid_system_section.generic.x - 
			MENU_FONT_SIZE*(strlen(s_vid_system_section.generic.name)+3);

		s_vid_advanced_section.generic.type				= MTYPE_ACTION;
		s_vid_advanced_section.generic.name				= "advanced";
		s_vid_advanced_section.generic.x				= MENU_FONT_SIZE * 1;
		s_vid_advanced_section.generic.y				= 0;
		s_vid_advanced_section.generic.callback			= setMenuAdvanced;
		s_vid_advanced_section.generic.cursor_offset	= s_vid_advanced_section.generic.x - 
			MENU_FONT_SIZE*(strlen(s_vid_advanced_section.generic.name)+3);

		s_vid_misc_section.generic.type				= MTYPE_ACTION;
		s_vid_misc_section.generic.name				= "miscellaneous";
		s_vid_misc_section.generic.x				= MENU_FONT_SIZE * 17;
		s_vid_misc_section.generic.y				= 0;
		s_vid_misc_section.generic.callback			= setMenuMiscellaneous;
		s_vid_misc_section.generic.cursor_offset	= s_vid_misc_section.generic.x - 
			MENU_FONT_SIZE*(strlen(s_vid_misc_section.generic.name)+3);

	}
	//SYSTEM
	{

		s_mode_list.generic.type = MTYPE_SPINCONTROL;
		s_mode_list.generic.name = "video mode";
		s_mode_list.generic.x = 0;
		s_mode_list.generic.y = MENU_FONT_SIZE*3+2;
		s_mode_list.itemnames = resolutions;
		s_mode_list.generic.statusbar	= "video resolution";
		
		s_fs_box.generic.type = MTYPE_SPINCONTROL;
		s_fs_box.generic.x	= 0;
		s_fs_box.generic.y	= MENU_FONT_SIZE*4+2;
		s_fs_box.generic.name	= "fullscreen";
		s_fs_box.itemnames = yesno_names;
		s_fs_box.curvalue = vid_fullscreen->value;

		s_screensize_slider.generic.type	= MTYPE_SLIDER;
		s_screensize_slider.generic.x		= 0;
		s_screensize_slider.generic.y		= MENU_FONT_SIZE*5+2;
		s_screensize_slider.generic.name	= "screen size";
		s_screensize_slider.minvalue = 3;
		s_screensize_slider.maxvalue = 12;
		s_screensize_slider.generic.callback = ScreenSizeCallback;

		s_brightness_slider.generic.type	= MTYPE_SLIDER;
		s_brightness_slider.generic.x	= 0;
		s_brightness_slider.generic.y	= MENU_FONT_SIZE*7+2;
		s_brightness_slider.generic.name	= "brightness";
		s_brightness_slider.generic.callback = BrightnessCallback;
		s_brightness_slider.minvalue = 5;
		s_brightness_slider.maxvalue = 13;
		s_brightness_slider.curvalue = ( 1.3 - vid_gamma->value + 0.5 ) * 10;

		s_tfilter_box.generic.type = MTYPE_SPINCONTROL;
		s_tfilter_box.generic.x	= 0;
		s_tfilter_box.generic.y	= MENU_FONT_SIZE*9+2;
		s_tfilter_box.generic.name	= "texture filter";
		s_tfilter_box.itemnames = texfilter_names;
		s_tfilter_box.curvalue			= texfilter_box_setval();	// Knightmare- added setval func
		s_tfilter_box.generic.callback	= TexFilterCallback;	// Knightmare- added callback
/*
		if (!Q_strcasecmp(gl_texturemode->string, "GL_NEAREST"))
			s_tfilter_box.curvalue = 0;
		else if (!Q_strcasecmp(gl_texturemode->string, "GL_NEAREST_MIPMAP_NEAREST"))
			s_tfilter_box.curvalue = 1;
		else if (!Q_strcasecmp(gl_texturemode->string, "GL_LINEAR"))
			s_tfilter_box.curvalue = 2;
		else if (!Q_strcasecmp(gl_texturemode->string, "GL_LINEAR_MIPMAP_NEAREST"))
			s_tfilter_box.curvalue = (gl_anisotropic->value)? 5 :3;
		else // if (!Q_strcasecmp(gl_texturemode->string, "GL_LINEAR_MIPMAP_LINEAR"))
			s_tfilter_box.curvalue = (gl_anisotropic->value)? 6 :4;
*/	
		// Knightmare- anisotropic filter option
		s_aniso_box.generic.type		= MTYPE_SPINCONTROL;
		s_aniso_box.generic.x			= 0;
		s_aniso_box.generic.y			= MENU_FONT_SIZE*10+2;
		s_aniso_box.generic.name		= "anisotropic filter";
		s_aniso_box.curvalue			= GetAnisoCurValue();
		s_aniso_box.itemnames			= GetAnisoNames();
		s_aniso_box.generic.statusbar	= "anisotropic mipmap filtering";
		s_aniso_box.generic.callback	= AnisoCallback;

		s_texqual_box.generic.type	= MTYPE_SPINCONTROL;
		s_texqual_box.generic.x		= 0;
		s_texqual_box.generic.y		= MENU_FONT_SIZE*11+2;
		s_texqual_box.generic.name	= "texture quality";
		s_texqual_box.itemnames = lmh_names;
		s_texqual_box.curvalue = ClampCvar( 0, 3, 3-gl_picmip->value );
/*
		s_texcompress_box.generic.type		= MTYPE_SPINCONTROL;
		s_texcompress_box.generic.x			= 0;
		s_texcompress_box.generic.y			= MENU_FONT_SIZE*11+2;
		s_texcompress_box.generic.name		= "texture compression";
		s_texcompress_box.itemnames			= yesno_names;
		s_texcompress_box.curvalue			= Cvar_VariableValue("gl_ext_texture_compression");
		s_texcompress_box.generic.statusbar	= "low quality textures";
*/
		// Knightmare- non-power-of-2 texture option
		s_npot_mipmap_box.generic.type		= MTYPE_SPINCONTROL;
		s_npot_mipmap_box.generic.x			= 0;
		s_npot_mipmap_box.generic.y			= MENU_FONT_SIZE*12+2;
		s_npot_mipmap_box.generic.name		= "non-power-of-2 mipmaps";
		s_npot_mipmap_box.itemnames			= yesno_names;
		s_npot_mipmap_box.curvalue			= Cvar_VariableValue("gl_nonpoweroftwo_mipmaps");
		s_npot_mipmap_box.generic.statusbar	= "enables non-power-of-2 mipmapped textures";

		s_vsync_box.generic.type = MTYPE_SPINCONTROL;
		s_vsync_box.generic.x	= 0;
		s_vsync_box.generic.y	= MENU_FONT_SIZE*14+2;
		s_vsync_box.generic.name	= "video sync";
		s_vsync_box.curvalue = Cvar_VariableValue("gl_swapinterval");
		s_vsync_box.itemnames = yesno_names;
		s_vsync_box.generic.statusbar	= "sync framerate with monitor refresh";
		s_vsync_box.generic.callback		= VsyncCallback;

		// Knightmare- refresh rate option
		s_refresh_box.generic.type			= MTYPE_SPINCONTROL;
		s_refresh_box.generic.x				= 0;
		s_refresh_box.generic.y				= MENU_FONT_SIZE*15+2;
		s_refresh_box.generic.name			= "refresh rate";
		s_refresh_box.curvalue				= refresh_box_setval();
		s_refresh_box.itemnames				= refreshrate_names;
		s_refresh_box.generic.statusbar		= "sets refresh rate for fullscreen modes";

		// Knightmare- widesreen fov option
		s_adjust_fov_box.generic.type		= MTYPE_SPINCONTROL;
		s_adjust_fov_box.generic.x			= 0;
		s_adjust_fov_box.generic.y			= MENU_FONT_SIZE*16+2;
		s_adjust_fov_box.generic.name		= "fov autoscaling";
		s_adjust_fov_box.generic.callback	= AdjustFOVCallback;
		s_adjust_fov_box.curvalue			= Cvar_VariableValue("cl_widescreen_fov");
		s_adjust_fov_box.itemnames			= yesno_names;
		s_adjust_fov_box.generic.statusbar	= "automatic scaling of fov for widescreen modes";
	}
	//ADVACNED
	{
		s_shaders_box.generic.type		= MTYPE_SPINCONTROL;
		s_shaders_box.generic.x			= 0;
		s_shaders_box.generic.y			= MENU_FONT_SIZE*3+2;
		s_shaders_box.generic.name		= "shaders";
		s_shaders_box.itemnames			= yesno_names;
		s_shaders_box.curvalue			= Cvar_VariableValue("r_shaders");
		s_shaders_box.generic.statusbar	= "dynamic texturing";

		s_glares_box.generic.type		= MTYPE_SPINCONTROL;
		s_glares_box.generic.x			= 0;
		s_glares_box.generic.y			= MENU_FONT_SIZE*5+2;
		s_glares_box.generic.name		= "screen glares";
		s_glares_box.itemnames			= glares_names;
		s_glares_box.curvalue			= Cvar_VariableValue("rs_glares");
		s_glares_box.generic.statusbar	= "light flare glaring";
		
		if (s_glares_box.curvalue >= 3)
			s_glares_box.curvalue = 3;
		else if (s_glares_box.curvalue >= 1.5)
			s_glares_box.curvalue = 2;
		else if (s_glares_box.curvalue)
			s_glares_box.curvalue = 1;
		else 
			s_glares_box.curvalue = 0;

		s_skyglares_box.generic.type		= MTYPE_SPINCONTROL;
		s_skyglares_box.generic.x			= 0;
		s_skyglares_box.generic.y			= MENU_FONT_SIZE*6+2;
		s_skyglares_box.generic.name		= "sky glares";
		s_skyglares_box.itemnames			= yesno_names;
		s_skyglares_box.curvalue			= Cvar_VariableValue("rs_glares_sky");

		s_shellglares_box.generic.type		= MTYPE_SPINCONTROL;
		s_shellglares_box.generic.x			= 0;
		s_shellglares_box.generic.y			= MENU_FONT_SIZE*7+2;
		s_shellglares_box.generic.name		= "shell glares";
		s_shellglares_box.itemnames			= yesno_names;
		s_shellglares_box.curvalue			= Cvar_VariableValue("rs_glares_shell");

		s_overbrights_box.generic.type = MTYPE_SPINCONTROL;
		s_overbrights_box.generic.x	= 0;
		s_overbrights_box.generic.y	= MENU_FONT_SIZE*9+2;
		s_overbrights_box.generic.name	= "overbrights";
		s_overbrights_box.itemnames = overbright_names;
		s_overbrights_box.curvalue = (int)(r_overbrightbits->value)>>1;

		s_transsort_box.generic.type		= MTYPE_SPINCONTROL;
		s_transsort_box.generic.x			= 0;
		s_transsort_box.generic.y			= MENU_FONT_SIZE*11+2;
		s_transsort_box.generic.name		= "transparency";
		s_transsort_box.itemnames			= sort_names;
		s_transsort_box.curvalue			= Cvar_VariableValue("gl_transrendersort");
		s_transsort_box.generic.statusbar	= "depth sorting routine";

		s_celshading_box.generic.type		= MTYPE_SPINCONTROL;
		s_celshading_box.generic.x			= 0;
		s_celshading_box.generic.y			= MENU_FONT_SIZE*13+2;
		s_celshading_box.generic.name		= "celshading";
		s_celshading_box.itemnames			= yesno_names;
		s_celshading_box.curvalue			= Cvar_VariableValue("r_celshading");
		s_celshading_box.generic.statusbar	= "cartoon style rendering";
	}
	//MISC
	{
		s_shadows_box.generic.type		= MTYPE_SPINCONTROL;
		s_shadows_box.generic.x			= 0;
		s_shadows_box.generic.y			= MENU_FONT_SIZE*3+2;
		s_shadows_box.generic.name		= "shadows";
		s_shadows_box.itemnames			= shadow_names;
		s_shadows_box.curvalue			= Cvar_VariableValue("gl_shadows");

		s_fps_box.generic.type		= MTYPE_SPINCONTROL;
		s_fps_box.generic.x			= 0;
		s_fps_box.generic.y			= MENU_FONT_SIZE*5+2;
		s_fps_box.generic.name		= "fps counter";
		s_fps_box.itemnames			= yesno_names;
		s_fps_box.curvalue			= Cvar_VariableValue("cl_drawfps");

		s_netgraph_box.generic.type		= MTYPE_SPINCONTROL;
		s_netgraph_box.generic.x		= 0;
		s_netgraph_box.generic.y		= MENU_FONT_SIZE*7+2;
		s_netgraph_box.generic.name		= "netgraph";
		s_netgraph_box.itemnames		= yesno_names;
		s_netgraph_box.curvalue			= Cvar_VariableValue("netgraph");
		
		s_netgpos_box.generic.type		= MTYPE_SPINCONTROL;
		s_netgpos_box.generic.x			= 0;
		s_netgpos_box.generic.y			= MENU_FONT_SIZE*8+2;
		s_netgpos_box.generic.name		= "netgraph position";
		s_netgpos_box.itemnames			= netgraph_names;
		s_netgpos_box.curvalue			= Cvar_VariableValue("netgraph_pos");

		s_particle_field.generic.type = MTYPE_FIELD;
		s_particle_field.generic.name = "particles";
		s_particle_field.generic.flags = QMF_NUMBERSONLY;
		s_particle_field.generic.x	= 0;
		s_particle_field.generic.y	= MENU_FONT_SIZE*10+4;
		s_particle_field.length = 4;
		s_particle_field.visible_length = 4;
		strcpy( s_particle_field.buffer, Cvar_VariableString("r_particles") );

		s_decal_field.generic.type = MTYPE_FIELD;
		s_decal_field.generic.name = "decals";
		s_decal_field.generic.flags = QMF_NUMBERSONLY;
		s_decal_field.generic.x	= 0;
		s_decal_field.generic.y	= MENU_FONT_SIZE*12+4;
		s_decal_field.length = 4;
		s_decal_field.visible_length =4;
		strcpy( s_decal_field.buffer, Cvar_VariableString("r_decals") );
	}


	s_defaults_action.generic.type = MTYPE_ACTION;
	s_defaults_action.generic.name = "reset to defaults";
	s_defaults_action.generic.x    = 0;
	s_defaults_action.generic.y    = MENU_FONT_SIZE*18+2;
	s_defaults_action.generic.callback = ResetDefaults;

	s_apply_action.generic.type = MTYPE_ACTION;
	s_apply_action.generic.name = "apply changes";
	s_apply_action.generic.x    = 0;
	s_apply_action.generic.y    = MENU_FONT_SIZE*19+2;
	s_apply_action.generic.callback = ApplyChanges;

//SYSTEM
	Menu_AddItem( &s_opengl_system_menu, ( void * ) &s_vid_system_section );
	Menu_AddItem( &s_opengl_system_menu, ( void * ) &s_vid_advanced_section );
	Menu_AddItem( &s_opengl_system_menu, ( void * ) &s_vid_misc_section );

	Menu_AddItem( &s_opengl_system_menu, ( void * ) &s_mode_list );
	Menu_AddItem( &s_opengl_system_menu, ( void * ) &s_fs_box );
	Menu_AddItem( &s_opengl_system_menu, ( void * ) &s_screensize_slider );
	Menu_AddItem( &s_opengl_system_menu, ( void * ) &s_brightness_slider );

	Menu_AddItem( &s_opengl_system_menu, ( void * ) &s_tfilter_box );
	Menu_AddItem( &s_opengl_system_menu, ( void * ) &s_aniso_box );	// Knightmare added
	Menu_AddItem( &s_opengl_system_menu, ( void * ) &s_texqual_box );
//	Menu_AddItem( &s_opengl_system_menu, ( void * ) &s_texcompress_box );
	Menu_AddItem( &s_opengl_system_menu, ( void * ) &s_npot_mipmap_box );	// Knightmare added

	Menu_AddItem( &s_opengl_system_menu, ( void * ) &s_vsync_box );
	Menu_AddItem( &s_opengl_system_menu, ( void * ) &s_refresh_box );	// Knightmare added
	Menu_AddItem( &s_opengl_system_menu, ( void * ) &s_adjust_fov_box );	// Knightmare added

	Menu_AddItem( &s_opengl_system_menu, ( void * ) &s_defaults_action );
	Menu_AddItem( &s_opengl_system_menu, ( void * ) &s_apply_action );
//ADVANCED
	Menu_AddItem( &s_opengl_advanced_menu, ( void * ) &s_vid_system_section );
	Menu_AddItem( &s_opengl_advanced_menu, ( void * ) &s_vid_advanced_section );
	Menu_AddItem( &s_opengl_advanced_menu, ( void * ) &s_vid_misc_section );

	Menu_AddItem( &s_opengl_advanced_menu, ( void * ) &s_shaders_box );

	Menu_AddItem( &s_opengl_advanced_menu, ( void * ) &s_glares_box );
	Menu_AddItem( &s_opengl_advanced_menu, ( void * ) &s_skyglares_box );
	Menu_AddItem( &s_opengl_advanced_menu, ( void * ) &s_shellglares_box );

	Menu_AddItem( &s_opengl_advanced_menu, ( void * ) &s_overbrights_box );

	Menu_AddItem( &s_opengl_advanced_menu, ( void * ) &s_transsort_box );

	Menu_AddItem( &s_opengl_advanced_menu, ( void * ) &s_celshading_box );

	Menu_AddItem( &s_opengl_advanced_menu, ( void * ) &s_defaults_action );
	Menu_AddItem( &s_opengl_advanced_menu, ( void * ) &s_apply_action );
//MISC
	Menu_AddItem( &s_opengl_misc_menu, ( void * ) &s_vid_system_section );
	Menu_AddItem( &s_opengl_misc_menu, ( void * ) &s_vid_advanced_section );
	Menu_AddItem( &s_opengl_misc_menu, ( void * ) &s_vid_misc_section );

	Menu_AddItem( &s_opengl_misc_menu, ( void * ) &s_shadows_box );
	Menu_AddItem( &s_opengl_misc_menu, ( void * ) &s_fps_box );

	Menu_AddItem( &s_opengl_misc_menu, ( void * ) &s_netgraph_box );
	Menu_AddItem( &s_opengl_misc_menu, ( void * ) &s_netgpos_box );

	Menu_AddItem( &s_opengl_misc_menu, ( void * ) &s_particle_field );
	Menu_AddItem( &s_opengl_misc_menu, ( void * ) &s_decal_field );

	Menu_AddItem( &s_opengl_misc_menu, ( void * ) &s_defaults_action );
	Menu_AddItem( &s_opengl_misc_menu, ( void * ) &s_apply_action );

//CONFIG
//	Menu_Center( &s_opengl_system_menu );
//	Menu_Center( &s_opengl_advanced_menu );
//	Menu_Center( &s_opengl_misc_menu );

	s_opengl_system_menu.x -= 8;
	s_opengl_advanced_menu.x -= 8;
	s_opengl_misc_menu.x -= 8;
}

/*
================
VID_MenuDraw
================
*/
void M_Banner( char *name );

void VID_MenuDraw (void)
{
//	int w, h;

	/*
	** draw the banner
	*/
	M_Banner("m_banner_video");
	/*
	** move cursor to a reasonable starting position
	*/

	if (video_menu->value == 0)
	{
		s_vid_system_section.generic.name		= "^2system";
		s_vid_advanced_section.generic.name		= "advanced";
		s_vid_misc_section.generic.name			= "miscellaneous";

		s_vid_system_section.generic.x			= MENU_FONT_SIZE * (-10+1);
		s_vid_advanced_section.generic.x		= MENU_FONT_SIZE * 1;
		s_vid_misc_section.generic.x			= MENU_FONT_SIZE * 17;

		Menu_AdjustCursor( &s_opengl_system_menu, 1 );
		Menu_Draw( &s_opengl_system_menu );
	}
	else if (video_menu->value == 1)
	{
		s_vid_system_section.generic.name		= "system";
		s_vid_advanced_section.generic.name		= "^2advanced";
		s_vid_misc_section.generic.name			= "miscellaneous";

		s_vid_system_section.generic.x			= MENU_FONT_SIZE * -10+1;
		s_vid_advanced_section.generic.x		= MENU_FONT_SIZE * (1+1);
		s_vid_misc_section.generic.x			= MENU_FONT_SIZE * 17;

		Menu_AdjustCursor( &s_opengl_advanced_menu, 1 );
		Menu_Draw( &s_opengl_advanced_menu );
	}
	else
	{
		s_vid_system_section.generic.name		= "system";
		s_vid_advanced_section.generic.name		= "advanced";
		s_vid_misc_section.generic.name			= "^2miscellaneous";

		s_vid_system_section.generic.x			= MENU_FONT_SIZE * -10;
		s_vid_advanced_section.generic.x		= MENU_FONT_SIZE * 1;
		s_vid_misc_section.generic.x			= MENU_FONT_SIZE * (17+1);

		Menu_AdjustCursor( &s_opengl_misc_menu, 1 );
		Menu_Draw( &s_opengl_misc_menu );
	}
}

/*
================
VID_MenuKey
================
*/

void vid_MoveMenuSelect (menuframework_s *m, int dir)
{

	if (m->cursor<3)
	{
		if (dir > 0)
		{
			m->cursor = 3;
			refreshCursorLink();
			Menu_AdjustCursor( m, 0 );
		}
		else
		{
			m->cursor = -1;
			refreshCursorLink();
			Menu_AdjustCursor( m, -1 );
		}
		return;
	}

	m->cursor += dir;
	refreshCursorLink();
	Menu_AdjustCursor( m, dir );
}

void vid_MoveMenuSlide (menuframework_s *m, int dir)
{
	if (m->cursor<3)
	{
		m->cursor += dir;

		if (m->cursor<0) { dir = 3; }
		if (m->cursor==3) { m->cursor=0; dir = 0; }

		Menu_AdjustCursor( m, dir );

		refreshCursorLink();
		return;
	}

	Menu_SlideItem(m, dir);
}

const char *VID_MenuKey( int key )
{
	menuframework_s *m;
	static const char *sound1 = "misc/menu1.wav";
	static const char *sound2 = "misc/menu2.wav";
	char *sound = sound1;
	menucommon_s *item;

	if (video_menu->value == 0)
		m = &s_opengl_system_menu;
	else if (video_menu->value == 1)
		m = &s_opengl_advanced_menu;
	else
		m = &s_opengl_misc_menu;

	if ( m )
		if ( ( item = Menu_ItemAtCursor( m ) ) != 0 )
			if ( item->type == MTYPE_FIELD )
				if ( Field_Key( ( menufield_s * ) item, key ) )
					return NULL;

	switch ( key )
	{
	case K_ESCAPE:
		CancelChanges( 0 );
		return NULL;
	case K_KP_UPARROW:
	case K_UPARROW:
		vid_MoveMenuSelect( m, -1 );
		sound = sound2;
		break;
	case K_KP_DOWNARROW:
	case K_DOWNARROW:
		vid_MoveMenuSelect( m, 1 );
		sound = sound2;
		break;
	case K_KP_LEFTARROW:
	case K_LEFTARROW:
		vid_MoveMenuSlide( m, -1 );
		sound = sound2;
		break;
	case K_KP_RIGHTARROW:
	case K_RIGHTARROW:
		vid_MoveMenuSlide( m, 1 );
		sound = sound2;
		break;
	case K_KP_ENTER:
	case K_ENTER:
		if ( !Menu_SelectItem( m ) )
			ApplyChanges( NULL );
		break;
	}

	return sound;
}


