// g_weapon.c

#include "g_local.h"
#include "m_player.h"

#define		MUZZLEON 1
#define		ROTSHOTMULT 1

#define		BFG_ROCKET_AMMO		20
#define		BFG_LASER_AMMO		20
#define		BFG_FRAME_LEAP		8

static qboolean	is_quad;
static byte		is_silenced;


void weapon_grenade_fire (edict_t *ent, qboolean held);

static void P_ProjectSource (gclient_t *client, vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result)
{
	vec3_t	_distance;

	VectorCopy (distance, _distance);
	if (client->pers.hand == LEFT_HANDED)
		_distance[1] *= -1;
	else if (client->pers.hand == CENTER_HANDED)
		_distance[1] = 0;
	G_ProjectSource (point, _distance, forward, right, result);
}


void flashThink (edict_t *ent)
{
	vec3_t start, forward, right;
	edict_t *flash;

	if (ent->owner && ent->owner->health>0)
	{
		if (ent->owner->client)
		{
			if (ent->owner->client->chasetoggle)
			{
				AngleVectors (ent->owner->s.angles, forward, right, NULL);
				G_ProjectSource (ent->owner->s.origin, ent->end_pt, forward, right, start);
				VectorCopy(ent->owner->s.angles, ent->s.angles);
			}
			else
			{
				AngleVectors (ent->owner->client->v_angle, forward, right, NULL);
				P_ProjectSource (ent->owner->client, ent->owner->s.origin, ent->end_pt, forward, right, start);
				VectorCopy(ent->owner->client->v_angle, ent->s.angles);
			}
		}
		else
		{
			AngleVectors (ent->owner->s.angles, forward, right, NULL);
			G_ProjectSource (ent->owner->s.origin, ent->end_pt, forward, right, start);
			VectorCopy(ent->owner->s.angles, ent->s.angles);
		}

		VectorCopy (start, ent->s.origin);
		ent->s.angles[2] = ent->random;
	}
	else
	{
		G_FreeEdict(ent);
		return;
	}

	ent->s.frame++;
	ent->s.skinnum++;

	if (ent->s.frame==0)
	{
		ent->s.modelindex = gi.modelindex ("models/objects/muzzleflash/tris.md2");
		VectorCopy (ent->s.origin, ent->s.old_origin);
	}
	else if (ent->s.frame==1)
	{
		ent->s.frame++;
		ent->s.skinnum++;
	}

	gi.linkentity (ent);

	if (ent->s.skinnum>2)
		G_FreeEdict(ent);
}

void MuzzleEffect (edict_t *ent, vec3_t start, vec3_t forward, vec3_t offset)
{
	if (!MUZZLEON)
		return;

	if (!sv_waterlevel->value)
	{
		if (ent->waterlevel<2 || !ent->client)
		{
			if (!sv_serversideonly->value && sv_mzlmodel->value)
			{
				edict_t	*mzlflash;

				mzlflash = G_Spawn();
				mzlflash->svflags = SVF_DEADMONSTER;
				if (ent->client && !ent->client->chasetoggle)
					vectoangles(forward, mzlflash->s.angles);
				else
					VectorCopy (ent->s.angles, mzlflash->s.angles);
				mzlflash->s.angles[2] = mzlflash->random = random()*360;			
				VectorCopy (start, mzlflash->s.origin);
				VectorCopy (start, mzlflash->s.old_origin);
				VectorCopy (offset, mzlflash->end_pt);
				mzlflash->movetype = MOVETYPE_NONE;
				mzlflash->clipmask = MASK_SHOT;
				mzlflash->solid = SOLID_NOT;
				mzlflash->s.effects = EF_SPHERETRANS;
				mzlflash->s.renderfx = RF_FULLBRIGHT;
				VectorClear (mzlflash->mins);
				VectorClear (mzlflash->maxs);
				mzlflash->s.frame = -2;
				mzlflash->s.skinnum = -2;
				mzlflash->thinklinked = flashThink;
				mzlflash->classname = "mzlflash";
				mzlflash->owner = ent;
				if (SPClient == ent)
					mzlflash->s.renderfx |= RF_DEPTHHACK;
				gi.linkentity (mzlflash);

				if (ent->client && ent->client->ps.pmove.pm_flags & PMF_NO_PREDICTION)
				{
					mzlflash->s.frame = 0;
					mzlflash->s.skinnum = 0;
				}
			}
			else
			{
				if (ent->client)
				{
					gi.WriteByte (svc_temp_entity);
					gi.WriteByte (TE_CHAINFIST_SMOKE);
					gi.WritePosition (start);
					gi.unicast (ent, 0);
				}
			}
		} else {
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (SPLASH_UNKNOWN);
			gi.WritePosition (start);
			gi.WriteDir (forward);
			gi.multicast (start, MULTICAST_PVS);
		}
	}
}

void AddKick (edict_t *ent, vec3_t forward, int amt)
{
	if ((ent->client->jets)||(ent->waterlevel&&ent->client->goggles)||sv_waterlevel->value)
		ent->client->lastSpeed-=amt*50;
	else if (!(ent->client->ps.pmove.pm_flags & PMF_DUCKED))
	{
		vec3_t forward2;

		VectorCopy(forward,forward2);
		VectorNormalize (forward2);
		VectorScale(forward2,((int)((amt*-1)*50)),forward2);

		ent->velocity[0]+=forward2[0];
		ent->velocity[1]+=forward2[1];
		ent->velocity[2]+=forward2[2]*(0.5);
	}
}

/*
===============
PlayerNoise

Each player can have two noise objects associated with it:
a personal noise (jumping, pain, weapon firing), and a weapon
target noise (bullet wall impacts)

Monsters that don't directly see the player can move
to a noise in hopes of seeing the player from there.
===============
*/
void PlayerNoise(edict_t *who, vec3_t where, int type)
{
	edict_t		*noise;

	if (type == PNOISE_WEAPON)
	{
		if (who->client->silencer_shots)
		{
			who->client->silencer_shots--;
			return;
		}
	}

	if (deathmatch->value)
		return;

	if (who->flags & FL_NOTARGET)
		return;


	if (!who->mynoise)
	{
		noise = G_Spawn();
		noise->classname = "player_noise";
		VectorSet (noise->mins, -8, -8, -8);
		VectorSet (noise->maxs, 8, 8, 8);
		noise->owner = who;
		noise->svflags = SVF_NOCLIENT;
		who->mynoise = noise;

		noise = G_Spawn();
		noise->classname = "player_noise";
		VectorSet (noise->mins, -8, -8, -8);
		VectorSet (noise->maxs, 8, 8, 8);
		noise->owner = who;
		noise->svflags = SVF_NOCLIENT;
		who->mynoise2 = noise;
	}

	if (type == PNOISE_SELF || type == PNOISE_WEAPON)
	{
		noise = who->mynoise;
		level.sound_entity = noise;
		level.sound_entity_framenum = level.framenum;
	}
	else // type == PNOISE_IMPACT
	{
		noise = who->mynoise2;
		level.sound2_entity = noise;
		level.sound2_entity_framenum = level.framenum;
	}

	VectorCopy (where, noise->s.origin);
	VectorSubtract (where, noise->maxs, noise->absmin);
	VectorAdd (where, noise->maxs, noise->absmax);
	noise->teleport_time = level.time;
	gi.linkentity (noise);
}


qboolean Pickup_Weapon (edict_t *ent, edict_t *other)
{
	int			index;
	int			banned = sv_banned_weapons->value;
//	int			i;
	gitem_t		*ammo;
	gitem_t		*addWeap;

	index = ITEM_INDEX(ent->item);

	if ( ( ((int)(dmflags->value) & DF_WEAPONS_STAY) ) && other->client->pers.inventory[index])
	{
		if (!(ent->spawnflags & (DROPPED_ITEM | DROPPED_PLAYER_ITEM) ) )
			return false;	// leave the weapon for others to pickup
	}
	
	if (other->client->pers.inventory[index] && coop->value)
		return false;

	other->client->pers.inventory[index]++;

	if (!(ent->spawnflags & DROPPED_ITEM) )
	{
		// give them some ammo with it
		ammo = FindItem (ent->item->ammo);
		if ( (int)dmflags->value & DF_INFINITE_AMMO )
			Add_Ammo (other, ammo, 1000);
		else
			Add_Ammo (other, ammo, ammo->quantity);

		if (! (ent->spawnflags & DROPPED_PLAYER_ITEM) )
		{
			if (deathmatch->value)
			{
				if ((int)(dmflags->value) & DF_WEAPONS_STAY)
					ent->flags |= FL_RESPAWN;
				else
					SetRespawn (ent, 30);
			}
			if (coop->value)
				ent->flags |= FL_RESPAWN;
		}
	}

	if (strcmp(ent->item->classname, "weapon_bfg") == 0 )
	{
		if (!(banned&NO_BFGLASER))
			Add_Ammo (other, FindItem("Cells"), 50);
		if (!(banned&NO_ROCKETBFG))
			Add_Ammo (other, FindItem("Rockets"), 50);
	}
	else if (strcmp(ent->item->classname, "weapon_railgun") == 0 )
	{
		if (!(banned&NO_TAZER))
			Add_Ammo (other, FindItem("Cells"), 10);
		if (!(banned&NO_RAILGUN))
			Add_Ammo (other, FindItem("Slugs"), 10);
	}
	else if (strcmp(ent->item->classname, "weapon_chaingun") == 0 )
	{
		Add_Ammo (other, FindItem("Shells"), 50);
	}

//auto switch ??
	/*
	if (other->client->pers.weapon != ent->item && 
		(other->client->pers.inventory[index] == 1) &&
		( !deathmatch->value || other->client->pers.weapon == FindItem("blaster") ) )
		other->client->newweapon = ent->item;	//*/

	return true;
}


/*
===============
ChangeWeapon

The old weapon has been dropped all the way, so make the new one
current
===============
*/
void ChangeWeapon (edict_t *ent)
{
	int i;
	
	if (!ent->client->grenade_blew_up&&ent->client->grenade_time)
	{
		//ent->client->grenade_time = level.time;'
		ent->client->grenade_blew_up = true;
		ent->client->weapon_sound = 0;
		if (ent->client->pers.weapon!=NULL)
			weapon_grenade_fire (ent, false);
		ent->client->grenade_time = 0;
	}

	ent->client->tazer = (ent->client->tazer) ? 10 : 0;

	//Reset a couple of vars here
	ent->client->blst_set = 0;
	ent->client->hypr_set = 0;
	ent->client->rock_set = 0;
	ent->client->mach_set = 0;
	ent->client->gren_set = 0;
	ent->client->chan_set = 0;
	ent->client->shot_set = 0;

	ent->client->pers.lastweapon = ent->client->pers.weapon;
	ent->client->pers.weapon = ent->client->newweapon;
	ent->client->newweapon = NULL;
	ent->client->machinegun_shots = 0;

	// set visible model
	if (ent->s.modelindex == 255) {
		if (ent->client->pers.weapon)
			i = ((ent->client->pers.weapon->weapmodel & 0xff) << 8);
		else
			i = 0;
		ent->s.skinnum = (ent - g_edicts - 1) | i;
	}

	if (ent->client->pers.weapon && ent->client->pers.weapon->ammo)
		ent->client->ammo_index = ITEM_INDEX(FindItem(ent->client->pers.weapon->ammo));
	else
		ent->client->ammo_index = 0;

	if (!ent->client->pers.weapon)
	{	// dead
		ent->client->ps.gunindex = 0;
		return;
	}

	ent->client->weaponstate = WEAPON_ACTIVATING;
	ent->client->ps.gunframe = 0;
	ent->client->ps.gunindex = gi.modelindex(ent->client->pers.weapon->view_model);

    /* Don't display weapon if chasetoggle is on */
    if (ent->client->chasetoggle)
	ent->client->ps.gunindex = 0;

	ent->client->anim_priority = ANIM_PAIN;
	if(ent->client->ps.pmove.pm_flags & PMF_DUCKED)
	{
			ent->s.frame = FRAME_crpain1;
			ent->client->anim_end = FRAME_crpain4;
	}
	else
	{
			ent->s.frame = FRAME_pain301;
			ent->client->anim_end = FRAME_pain304;
			
	}
}

/*
=================
NoAmmoWeaponChange
=================
*/
void NoAmmoWeaponChange (edict_t *ent)
{
	//Reset a couple of vars here
	ent->client->blst_set = 0;
	ent->client->hypr_set = 0;
	ent->client->rock_set = 0;
	ent->client->mach_set = 0;
	ent->client->gren_set = 0;
	ent->client->chan_set = 0;
	ent->client->shot_set = 0;
	ent->client->bfg_set  = 0;
	ent->client->rail_set = 0;
	
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("slugs"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("railgun"))] )
	{
		ent->client->newweapon = FindItem ("railgun");
		return;
	}
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("cells"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("hyperblaster"))] )
	{
		ent->client->newweapon = FindItem ("hyperblaster");
		return;
	}
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("bullets"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("chaingun"))] )
	{
		ent->client->newweapon = FindItem ("chaingun");
		return;
	}
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("bullets"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("machinegun"))] )
	{
		ent->client->newweapon = FindItem ("machinegun");
		return;
	}
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("shells"))] > 1
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("super shotgun"))] )
	{
		ent->client->newweapon = FindItem ("super shotgun");
		return;
	}
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("shells"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("shotgun"))] )
	{
		ent->client->newweapon = FindItem ("shotgun");
		return;
	}
	ent->client->newweapon = FindItem ("blaster");
}

/*
=================
Think_Weapon

Called by ClientBeginServerFrame and ClientThink
=================
*/
void Think_Weapon (edict_t *ent)
{
	// if just died, put the weapon away
	if (ent->health < 1)
	{
		ent->client->newweapon = NULL;
		ChangeWeapon (ent);
	}

	if (ent->client->isOnTurret)
		return;

//	if (ent->client->stunts<-5)
//		ent->client->ps.pmove.pm_flags &= PMF_DUCKED;

	// call active weapon think routine
	if (ent->client->pers.weapon && ent->client->pers.weapon->weaponthink)
	{
		is_quad = (ent->client->quad_framenum > level.framenum);
		if (ent->client->silencer_shots)
			is_silenced = MZ_SILENCED;
		else
			is_silenced = 0;
		ent->client->pers.weapon->weaponthink (ent);
	}
}


/*
================
Use_Weapon

Make the weapon ready if there is ammo
================
*/
void Use_Weapon (edict_t *ent, gitem_t *item)
{
//	int			ammo_index;
//	gitem_t		*ammo_item;

	int			banned = sv_banned_weapons->value;
	char		*msg="";
	int			ismsg=0;

	ent->client->tazer = (ent->client->tazer) ? 10 : 0;

	if (item == ent->client->pers.weapon)
	{
		if (!Q_strcasecmp(item->pickup_name,"Grenade Launcher"))
			if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Grenade Launcher"))
			{
				if (ent->client->grn_set==0)
				{
					ent->client->grn_set=1;
    				ent->client->grnl_set=0;
					ent->client->gren_set=2;
					msg = "Normal Gas Grenade Launcher\n";
				}
				else if (ent->client->grn_set==1)
				{
					ent->client->grn_set=2;
    				ent->client->grnl_set=0;
					ent->client->gren_set=3;
					msg = "Normal Cluster Grenade Launcher\n";
				}
				else if (ent->client->grn_set==2)
				{
					ent->client->grn_set=3;
    				ent->client->grnl_set=0;
					ent->client->gren_set=1;
					msg = "Normal Flashbang Launcher\n";
				}
				else if (ent->client->grn_set==3)
				{
					ent->client->grn_set=4;
    				ent->client->grnl_set=1;
					ent->client->gren_set=0;
					msg = "Sticky Fragmentation Grenade Launcher\n";
				}
				else if (ent->client->grn_set==4)
				{
					ent->client->grn_set=5;
    				ent->client->grnl_set=1;
					ent->client->gren_set=2;
					msg = "Sticky Gas Grenade Launcher\n";
				}
				else if (ent->client->grn_set==5)
				{
					ent->client->grn_set=6;
    				ent->client->grnl_set=1;
					ent->client->gren_set=3;
					msg = "Sticky Cluster Grenade Launcher\n";
				}
				else if (ent->client->grn_set==6)
				{
					ent->client->grn_set=7;
    				ent->client->grnl_set=1;
					ent->client->gren_set=1;
					msg = "Sticky Flashbang Launcher\n";
				}
				else
				{
					ent->client->grn_set=0;
    				ent->client->grnl_set=0;
					ent->client->gren_set=0;
					msg = "Normal Fragmentation Grenade Launcher\n";
				}											

				ismsg = 1;
			}

		if (!Q_strcasecmp(item->pickup_name,"Grenades"))
			if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Grenades"))
			{
				if (ent->client->gren_set==1)
				{
    				ent->client->gren_set=0;
					msg = "Fragmentation Grenades\n";
				}
				else if (ent->client->gren_set==3)
				{
					ent->client->gren_set=1;
					msg = "Flashbangs\n";
				}
				else if (ent->client->gren_set==0)
				{
					ent->client->gren_set=2;
					msg = "Gas Grenades\n";
				}
				else
				{
					ent->client->gren_set=3;
					msg = "Cluster Grenades\n";
				}
				ismsg = 1;
			}
		if (!Q_strcasecmp(item->pickup_name,"Rocket Launcher"))
			if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Rocket Launcher"))
			{
				if (ent->client->rock_set==1)
				{
    				ent->client->rock_set=0;
					msg = "Direct Fire Rockets\n";
				}
				else
				{
					ent->client->rock_set=1;
					msg = "Indirect Fire Rockets\n";
				}

				ismsg = 1;
			}

		if (!Q_strcasecmp(item->pickup_name,"Chaingun"))
			if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Chaingun"))
			{
				if (ent->client->chan_set==1)
				{
    				ent->client->chan_set=0;
					msg = "Minigun\n";
				}
				else
				{
					ent->client->chan_set=1;
					msg = "Rotary Shotgun\n";
				}

				ismsg = 1;
			}

		if (!Q_strcasecmp(item->pickup_name,"Shotgun"))
			if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Shotgun"))
			{
				if (ent->client->shot_set==1)
				{
    				ent->client->shot_set=0;
					msg = "Auto-Shotgun Shells\n";
				}
				else
				{
					ent->client->shot_set=1;
					msg = "Auto-Cannon Slugs\n";
				}

				ismsg = 1;
			}

		if (!Q_strcasecmp(item->pickup_name,"Super Shotgun"))
			if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Super Shotgun"))
			{
				if (ent->client->shot_set==1)
				{
    				ent->client->shot_set=0;
					msg = "Super Shotgun Shells\n";
				}
				else
				{
					ent->client->shot_set=1;
					msg = "Super Shotgun Slugs\n";
				}

				ismsg = 1;
			}

		if (!Q_strcasecmp(item->pickup_name,"Machinegun"))
			if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Machinegun"))
			{
				if (ent->client->mach_set==1)
				{
    				ent->client->mach_set=0;
					msg = "SubMachinegun Rapid Fire\n";
				}
				else
				{
					ent->client->mach_set=1;
					msg = "SubMachinegun Burst Fire\n";
				}

				ismsg = 1;
			}

		if (!Q_strcasecmp(item->pickup_name,"Hyperblaster"))
			if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Hyperblaster"))
			{
				if (ent->client->hypr_set==1)
				{
    				ent->client->hypr_set=0;
					ent->client->machinegun_shots=0;
					msg = "Flame Thrower\n";
				}
				else
				{
					ent->client->hypr_set=1;
					ent->client->machinegun_shots=0;
					msg = "Plasma Rifle\n";
				}

				ismsg = 1;
			}

		if (!Q_strcasecmp(item->pickup_name,"Blaster"))
			if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Blaster"))
			{
				if (ent->client->blst_set==1)
				{
    				ent->client->blst_set=0;
					ent->client->machinegun_shots=0;
					msg = ".50 Calibre Ammunition\n";
				}
				else
				{
					ent->client->blst_set=1;
					ent->client->machinegun_shots=0;
					msg = "Smack\n";
				}

				ismsg = 1;
			}

		if ( (!sv_waterlevel->value)&&(!Q_strcasecmp(item->pickup_name,"Railgun")) )
			if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"Railgun"))
			{
				if (ent->client->rail_set==1)
				{
					ent->client->rail_set=0;
					msg = ".50 Calibre Sniper Rifle\n";
				}
				else if (!sv_waterlevel->value)
				{
    				ent->client->rail_set=1;
					msg = "Tazer\n";
				}

				ismsg = 1;
			}

		if (!Q_strcasecmp(item->pickup_name,"bfg10k"))
			if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name,"bfg10k"))
			{
				if (ent->client->bfg_set==2)
				{
					ent->client->bfg_set=0;
					msg = "Nuke Launcher Operational\n";
				}
				else
				{
    				ent->client->bfg_set=2;
					msg = "Heavy Laser Operational\n";
				}

				ismsg = 1;
			}
	}//*/

	if (banned&NO_BFGLASER && ent->client->bfg_set==2)
		ent->client->bfg_set=1;
	if (banned&NO_ROCKETBFG && ent->client->bfg_set==1)
		ent->client->bfg_set=2;
	if (banned&NO_RAILGUN && ent->client->rail_set==0)
		ent->client->rail_set=1;
	if (banned&NO_TAZER && ent->client->rail_set==1)
		ent->client->rail_set=0;

	if (ismsg==1)
		gi.cprintf (ent, PRINT_HIGH, msg);
	
	// see if we're already using it
	if (item == ent->client->pers.weapon)
		return;

/*	if (item->ammo && !g_select_empty->value && !(item->flags & IT_AMMO))
	{
		ammo_item = FindItem(item->ammo);
		ammo_index = ITEM_INDEX(ammo_item);

		if (!ent->client->pers.inventory[ammo_index])
		{
			gi.cprintf (ent, PRINT_HIGH, "No %s for %s.\n", ammo_item->pickup_name, item->pickup_name);
			return;
		}

		if (ent->client->pers.inventory[ammo_index] < item->quantity)
		{
			gi.cprintf (ent, PRINT_HIGH, "Not enough %s for %s.\n", ammo_item->pickup_name, item->pickup_name);
			return;
		}
	}*/

	// change to this weapon when down


	ent->client->newweapon = item;

	if (ent->client->pers.weapon==NULL)
	{
		//PULL OUT WEAPON
			//ent->client->newweapon = ent->client->pers.lastweapon;
			ChangeWeapon (ent);
			gi.cprintf(ent, PRINT_HIGH, "Regen-Stealth Suit - Off\n");
		ent->client->aquasuit = 0;
	}
}



/*
================
Drop_Weapon
================
*/
void Drop_Weapon (edict_t *ent, gitem_t *item)
{
	int		index;

	if ((int)(dmflags->value) & DF_WEAPONS_STAY)
		return;

	index = ITEM_INDEX(item);
	// see if we're already using it
	if (item == ent->client->pers.weapon)
	{
		if (!Q_strcasecmp(ent->client->pers.weapon->pickup_name, base_weapon))
		{
			gi.cprintf (ent, PRINT_HIGH, "Can't drop current weapon\n");
			return;
		}
		ent->client->newweapon = FindItem (base_weapon);
		ChangeWeapon (ent);
	}

	Drop_Item (ent, item);
	ent->client->pers.inventory[index]--;
}


/*
================
Weapon_Generic

A generic function to handle the basics of weapon thinking
================
*/
#define FRAME_FIRE_FIRST		(FRAME_ACTIVATE_LAST + 1)
#define FRAME_IDLE_FIRST		(FRAME_FIRE_LAST + 1)
#define FRAME_DEACTIVATE_FIRST	(FRAME_IDLE_LAST + 1)

void Weapon_Generic (edict_t *ent, int FRAME_ACTIVATE_LAST, int FRAME_FIRE_LAST, int FRAME_IDLE_LAST, int FRAME_DEACTIVATE_LAST, int *pause_frames, int *fire_frames, void (*fire)(edict_t *ent))
{
	int		n;

	if(ent->deadflag || ent->s.modelindex != 255) // VWep animations screw up corpses
	{
		return;
	}


	if (ent->client->weaponstate == WEAPON_DROPPING)
	{
		if (ent->client->ps.gunframe == FRAME_DEACTIVATE_LAST)
		{
			ChangeWeapon (ent);
			return;
		}
		else if ((FRAME_DEACTIVATE_LAST - ent->client->ps.gunframe) == 4)
		{
			ent->client->anim_priority = ANIM_REVERSE;
			if(ent->client->ps.pmove.pm_flags & PMF_DUCKED)
			{
				ent->s.frame = FRAME_crpain4+1;
				ent->client->anim_end = FRAME_crpain1;
			}
			else
			{
				ent->s.frame = FRAME_pain304+1;
				ent->client->anim_end = FRAME_pain301;
				
			}
		}

		ent->client->ps.gunframe++;
		return;
	}

	if (ent->client->weaponstate == WEAPON_ACTIVATING)
	{
		if (ent->client->ps.gunframe == FRAME_ACTIVATE_LAST)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = FRAME_IDLE_FIRST;
			return;
		}

		ent->client->ps.gunframe++;
		return;
	}

	if ((ent->client->newweapon) && (ent->client->weaponstate != WEAPON_FIRING))
	{
		ent->client->weaponstate = WEAPON_DROPPING;
		ent->client->ps.gunframe = FRAME_DEACTIVATE_FIRST;

		if ((FRAME_DEACTIVATE_LAST - FRAME_DEACTIVATE_FIRST) < 4)
		{
			ent->client->anim_priority = ANIM_REVERSE;
			if(ent->client->ps.pmove.pm_flags & PMF_DUCKED)
			{
				ent->s.frame = FRAME_crpain4+1;
				ent->client->anim_end = FRAME_crpain1;
			}
			else
			{
				ent->s.frame = FRAME_pain304+1;
				ent->client->anim_end = FRAME_pain301;
				
			}
		}
		return;
	}

	if (ent->client->weaponstate == WEAPON_READY)
	{
		if ( ((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK) )
		{
			ent->client->latched_buttons &= ~BUTTON_ATTACK;
			if ((!ent->client->ammo_index) || 
				( ent->client->pers.inventory[ent->client->ammo_index] >= ent->client->pers.weapon->quantity))
			{
				ent->client->ps.gunframe = FRAME_FIRE_FIRST;
				ent->client->weaponstate = WEAPON_FIRING;

				// start the animation
				ent->client->anim_priority = ANIM_ATTACK;
				if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
				{
					ent->s.frame = FRAME_crattak1-1;
					ent->client->anim_end = FRAME_crattak9;
				}
				else
				{
					ent->s.frame = FRAME_attack1-1;
					ent->client->anim_end = FRAME_attack8;
				}
			}
			else
			{
				if (level.time >= ent->pain_debounce_time)
				{
					gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
					ent->pain_debounce_time = level.time + 1;
				}
				//NoAmmoWeaponChange (ent);
			}
		}
		else
		{
			if (ent->client->ps.gunframe == FRAME_IDLE_LAST)
			{
				ent->client->ps.gunframe = FRAME_IDLE_FIRST;
				return;
			}

			if (pause_frames)
			{
				for (n = 0; pause_frames[n]; n++)
				{
					if (ent->client->ps.gunframe == pause_frames[n])
					{
						if (rand()&15)
							return;
					}
	
			}
			}
			ent->client->ps.gunframe++;
			return;
		}
	}

	if (ent->client->weaponstate == WEAPON_FIRING)
	{
		for (n = 0; fire_frames[n]; n++)
		{
			if (ent->client->ps.gunframe == fire_frames[n])
			{
				if (ent->client->quad_framenum > level.framenum)
					gi.sound(ent, CHAN_ITEM, gi.soundindex("items/damage3.wav"), 1, ATTN_NORM, 0);

				fire (ent);
				break;
			}
		}

		if (!fire_frames[n])
			ent->client->ps.gunframe++;

		if (ent->client->ps.gunframe == FRAME_IDLE_FIRST+1)
			ent->client->weaponstate = WEAPON_READY;
	}


}


/*
======================================================================

GRENADE

======================================================================
*/

#define GRENADE_TIMER		3
#define GRENADE_MINSPEED	400
#define GRENADE_MAXSPEED	800

void weapon_grenade_fire (edict_t *ent, qboolean held)
{
	vec3_t	offset;
	vec3_t	forward, right;
	vec3_t	start;
//	vec3_t	aim;
	int		damage = damage =150 + (int)(random() * 100.0);
	float	timer;
	int		speed;
	float	radius;

	radius = 300;
	if (is_quad)
		damage *= 4;

	VectorSet(offset, 8, 8, ent->viewheight-8);
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	timer = ent->client->grenade_time - level.time;
	speed = GRENADE_MINSPEED + (GRENADE_TIMER - timer) * ((GRENADE_MAXSPEED - GRENADE_MINSPEED) / GRENADE_TIMER);

	if (ent->health<1)
		speed=10;
	
	fire_grenade2 (ent, start, forward, damage, speed, timer, radius, held);

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index]--;

	ent->client->grenade_time = level.time + 1.0;

	if(ent->deadflag || ent->s.modelindex != 255) // VWep animations screw up corpses
	{
		return;
	}

	if (ent->health <= 0)
		return;

	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
	{
		ent->client->anim_priority = ANIM_ATTACK;
		ent->s.frame = FRAME_crattak1-1;
		ent->client->anim_end = FRAME_crattak3;
	}
	else
	{
		ent->client->anim_priority = ANIM_REVERSE;
		ent->s.frame = FRAME_wave08;
		ent->client->anim_end = FRAME_wave01;
	}
}


void Weapon_Grenade (edict_t *ent)
{

	ent->client->weaphold	= 0;
//	ent->client->gren_set	= 0;


	if ((ent->client->newweapon) && (ent->client->weaponstate == WEAPON_READY))
	{
		ChangeWeapon (ent);
		return;
	}

	if (ent->client->weaponstate == WEAPON_ACTIVATING)
	{
		ent->client->weaponstate = WEAPON_READY;
		ent->client->ps.gunframe = 16;
		return;
	}

	if (ent->client->weaponstate == WEAPON_READY)
	{
		if ( ((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK) )
		{
			ent->client->latched_buttons &= ~BUTTON_ATTACK;
			if (ent->client->pers.inventory[ent->client->ammo_index])
			{
				ent->client->ps.gunframe = 1;
				ent->client->weaponstate = WEAPON_FIRING;
				ent->client->grenade_time = 0;
			}
			else
			{
				if (level.time >= ent->pain_debounce_time)
				{
					gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
					ent->pain_debounce_time = level.time + 1;
				}
				//NoAmmoWeaponChange (ent);
			}
			return;
		}

		if ((ent->client->ps.gunframe == 29) || (ent->client->ps.gunframe == 34) || (ent->client->ps.gunframe == 39) || (ent->client->ps.gunframe == 48))
		{
			if (rand()&15)
				return;
		}

		if (++ent->client->ps.gunframe > 48)
			ent->client->ps.gunframe = 16;
		return;
	}

	if (ent->client->weaponstate == WEAPON_FIRING)
	{
		if (ent->client->ps.gunframe == 5)
			gi.sound(ent, CHAN_WEAPON, gi.soundindex("weapons/hgrena1b.wav"), 1, ATTN_NORM, 0);

		if (ent->client->ps.gunframe == 11)
		{
			if (!ent->client->grenade_time)
			{
				ent->client->grenade_time = level.time + GRENADE_TIMER + 0.2;
				ent->client->weapon_sound = gi.soundindex("weapons/hgrenc1b.wav");
			}

			// they waited too long, detonate it in their hand
			if (!ent->client->grenade_blew_up && level.time >= ent->client->grenade_time)
			{
				ent->client->weapon_sound = 0;
				weapon_grenade_fire (ent, true);
				ent->client->grenade_blew_up = true;
			}

			if (ent->client->buttons & BUTTON_ATTACK)
				return;

			if (ent->client->grenade_blew_up)
			{
				if (level.time >= ent->client->grenade_time)
				{
					ent->client->ps.gunframe = 15;
					ent->client->grenade_blew_up = false;
				}
				else
				{
					return;
				}
			}
		}

		if (ent->client->ps.gunframe == 12)
		{
			ent->client->weapon_sound = 0;
			weapon_grenade_fire (ent, false);
		}

		if ((ent->client->ps.gunframe == 15) && (level.time < ent->client->grenade_time))
			return;

		ent->client->ps.gunframe++;

		if (ent->client->ps.gunframe == 16)
		{
			ent->client->grenade_time = 0;
			ent->client->weaponstate = WEAPON_READY;
		}
	}
}

/*
======================================================================

GRENADE LAUNCHER

======================================================================
*/

void weapon_grenadelauncher_fire (edict_t *ent)
{
	vec3_t	offset;
	vec3_t	forward, right;
	vec3_t	start;
	int		damage =150 + (int)(random() * 100.0), speed;
	float	radius = 300;
	
	if (is_quad) {
		damage *= 3;
		radius *= 2;
	}

	VectorSet(offset, 8, 8, ent->viewheight-8);
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -1;
	forward[2]+=0.4;
	//fire_grenade (ent, start, forward, damage, 600, 2.5, radius);
	//fire_rocket_2 (ent, start, forward, damage, 1000, radius, radius);

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		if (ent->client->pers.inventory[ent->client->ammo_index]<=0)
		{
			ent->client->ps.gunframe++;
			return;
		}


	if ((ent->client->buttons & BUTTON_ATTACK) && ent->client->ps.gunframe>12)
	{
		ent->client->ps.gunframe = 8;
		return;
	}
	else if (ent->client->ps.gunframe>12)
	{
		ent->client->ps.gunframe++;
		return;
	}
	else
	{
		
		speed  = (sv_waterlevel->value)? 300: 700;
		fire_grenade2 (ent, start, forward, damage, speed, GRENADE_TIMER, radius, 1);

		AddKick (ent, forward, 2);

		gi.WriteByte (svc_muzzleflash);
		gi.WriteShort (ent-g_edicts);
		gi.WriteByte (MZ_GRENADE | is_silenced);
		gi.multicast (ent->s.origin, MULTICAST_PVS);

		PlayerNoise(ent, start, PNOISE_WEAPON);

		if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
			ent->client->pers.inventory[ent->client->ammo_index]--;
		
		ent->client->ps.gunframe++;
	}


}

void Weapon_GrenadeLauncher (edict_t *ent)
{
	static int	pause_frames[]	= {34, 51, 59, 0};
	static int	fire_frames[]	= {8, 13, 14, 15};

	ent->client->weaphold=6;

	Weapon_Generic (ent, 5, 16, 59, 64, pause_frames, fire_frames, weapon_grenadelauncher_fire);
}




/*
======================================================================

ROCKET

======================================================================
*/

void Weapon_RocketLauncher_Fire (edict_t *ent)
{
	vec3_t	offset, start;
	vec3_t	forward, right;
	int		damage;
	float	damage_radius;
	int		radius_damage;
	int		speed;
	damage = 200 + (int)(random() * 100.0);
	radius_damage = 200;
	damage_radius = 200;
	if (is_quad)
	{
		damage *= 4;
		radius_damage *= 4;
	}

	AngleVectors (ent->client->v_angle, forward, right, NULL);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -1;

	VectorSet(offset, 8, 6, ent->viewheight-12);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);


	//right hand first
	//VectorSet(offset, 8, 8, ent->viewheight-8);
	//G_ProjectSource(ent->s.origin, offset, forward, right, start);
	if (ent->client->laser_on)
	{
		damage*=1.5;
		start[2]+=10;
		speed=(sv_waterlevel->value)? 1000: 750;
		fire_rocket (ent, start, forward, damage, speed, damage_radius, radius_damage);
	}
	else
	{
		if (ent->client->rock_set == 1)
		{
			forward[2]+=0.4;
			damage*=2;
			damage_radius*=1.5;
			speed=(sv_waterlevel->value)? 500: 1000;
			fire_rocket (ent, start, forward, damage, speed, damage_radius, radius_damage);
			AddKick (ent, forward, 5);
		}
		else
		{
			speed=(sv_waterlevel->value)? 750: 1500;
			fire_rocket (ent, start, forward, damage, speed, damage_radius, radius_damage);
			AddKick (ent, forward, 5);
		}
	}
	// send muzzle flash
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_ROCKET | is_silenced);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	ent->client->ps.gunframe++;

	PlayerNoise(ent, start, PNOISE_WEAPON);

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index]--;
}

void Weapon_RocketLauncher (edict_t *ent)
{
	static int	pause_frames[]	= {25, 33, 42, 50, 0};
	static int	fire_frames[]	= {5, 0};

	if (ent->client->laser_on)
		ent->client->weaphold=11;
	else
		ent->client->weaphold=7;


	Weapon_Generic (ent, 4, 20, 50, 54, pause_frames, fire_frames, Weapon_RocketLauncher_Fire);
}


/*
======================================================================

BLASTER / HYPERBLASTER

======================================================================
*/

void Smack_Fire (edict_t *ent, vec3_t start, vec3_t forward)
{
	fire_smack (ent, start, forward);
}

void Blaster_Fire (edict_t *ent, vec3_t g_offset, int damage, qboolean hyper, int effect)
{
	vec3_t	forward, right;
	vec3_t	start, end;
	vec3_t	offset;

	if (is_quad)
		damage *= 4;
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	//VectorSet(offset, 24, 8, ent->viewheight-8);
	VectorSet(offset, 10, 3, ent->viewheight);
	
	VectorAdd (offset, g_offset, offset);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -1;

	fire_blaster_hyper (ent, start, forward, damage, 50, effect, hyper);
}

void Plasma_Fire (edict_t *ent, vec3_t g_offset, int damage)
{
	vec3_t	forward, right, vert;
	vec3_t	start;
	vec3_t	offset;

	if (is_quad)
		damage *= 4;
	VectorCopy(ent->client->v_angle, vert);
	vert[2]*=1.5;
	AngleVectors (vert, forward, right, NULL);
	//VectorSet(offset, 24, 8, ent->viewheight-8);
	VectorSet(offset, 10, 8, ent->viewheight);
	VectorAdd (offset, g_offset, offset);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -1;

	fire_plasma (ent, start, forward, damage, 1500, 0, 0);
}

void Weapon_Blaster_Fire (edict_t *ent, int spread)
{
	vec3_t		start;
	vec3_t		forward, right;//, up;
	vec3_t		offset;
	vec3_t		offset2, start2;
	int			damage;
	int			kick;

	ent->client->machinegun_shots = 0;

	damage = 50+(int)(random()*10);
	kick = 80;


	if (is_quad)
	{
		damage *= 4;
		kick *= 4;
	}

	AngleVectors (ent->client->v_angle, forward, right, NULL);

	VectorScale (forward, -3, ent->client->kick_origin);
	ent->client->kick_angles[0] = -3;

	VectorSet(offset, 0, 6,  ent->viewheight-4); //VectorSet(offset, 0, 7,  ent->viewheight-8);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	VectorSet(offset2, 20, 6,  ent->viewheight-3);
	P_ProjectSource (ent->client, ent->s.origin, offset2, forward, right, start2);
	if (ent->client->oldplayer && ent->client->chasetoggle)
		G_ProjectSource (ent->client->oldplayer->s.origin, offset2, forward, right, start2);

	if (ent->client->blst_set==0)
	{
		if (ent->client->pers.inventory[ent->client->ammo_index]>0)
		{
			fire_bullet (ent, start, forward, damage, kick, spread, spread, MOD_BLASTER);
			
			ent->client->machinegun_shots = 1;

			MuzzleEffect (ent, start2, forward, offset2);

			if (sv_serversideonly->value)
			{
				gi.sound(ent, CHAN_AUTO, gi.soundindex("soldier/solatck1.wav"), 0.6, ATTN_IDLE, 0);
				gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/shotgf1b.wav"), 1.0, ATTN_IDLE, 0);
				gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/machgf4b.wav"), 1.0, ATTN_IDLE, 0);
			}
			else
			{				
				gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/handgun.wav"), 0.75, ATTN_IDLE, 0);
			}

			ent->client->ps.gunframe++;

			if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
				ent->client->pers.inventory[ent->client->ammo_index]--;

			if (ent->groundentity)
				AddKick (ent, forward, 1);
		}
		else
		{
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->client->ps.gunframe++;
		}
	}
	else
	{
		
		ent->client->hitmode = 1;
		Smack_Fire (ent, start, forward);

		ent->client->machinegun_shots = 1;
		ent->client->ps.gunframe++;
	}
}

void Weapon_Blaster_Fire1 (edict_t *ent)
{
	Weapon_Blaster_Fire (ent, DEFAULT_BULLET_HSPREAD/4);
}
void Weapon_Blaster_Fire2 (edict_t *ent)
{
	Weapon_Blaster_Fire (ent, DEFAULT_BULLET_HSPREAD/2);
}
void Weapon_Blaster_Fire3 (edict_t *ent)
{
	Weapon_Blaster_Fire (ent, DEFAULT_BULLET_HSPREAD);
}
void Weapon_Blaster_Fire4 (edict_t *ent)
{
	Weapon_Blaster_Fire (ent, DEFAULT_BULLET_HSPREAD*2);
}

void Weapon_Blaster (edict_t *ent)
{
	int firetype = 0;
	static int	pause_frames[]	= {19, 32, 0};
	static int	fire_frames[]	= {5, 0};

	ent->client->weaphold=1;
	
	if (ent->client->blst_set==0)
	{
		if ((ent->client->weaponstate == WEAPON_FIRING || ent->client->weaponstate == WEAPON_READY)
			&& !ent->client->heldfire && (ent->client->buttons & BUTTON_ATTACK) && ent->client->ps.gunframe!=6)
		{
			if (ent->client->ps.gunframe<9)
				firetype = abs(5-ent->client->ps.gunframe);
			ent->client->ps.gunframe = 9;
			ent->client->weaponstate = WEAPON_READY;
			ent->client->latched_buttons |= BUTTON_ATTACK;
			ent->client->heldfire = true;
		}
		else
		{
			ent->client->buttons &= ~BUTTON_ATTACK;
			ent->client->latched_buttons &= ~BUTTON_ATTACK;
		}
	}
	else
		ent->client->heldfire = false;

	if (firetype==0)
		Weapon_Generic (ent, 4, 8, 52, 55, pause_frames, fire_frames, Weapon_Blaster_Fire1);
	else if (firetype==1)
		Weapon_Generic (ent, 4, 8, 52, 55, pause_frames, fire_frames, Weapon_Blaster_Fire2);
	else if (firetype==2)
		Weapon_Generic (ent, 4, 8, 52, 55, pause_frames, fire_frames, Weapon_Blaster_Fire3);
	else if (firetype==3)
		Weapon_Generic (ent, 4, 8, 52, 55, pause_frames, fire_frames, Weapon_Blaster_Fire4);
}


void Weapon_HyperBlaster_Fire (edict_t *ent)
{
	float	rotation;
	vec3_t	g_offset;
	int		effect;
	int		damage;
	//from blaster base code
	vec3_t	forward, right, offset;
	vec3_t	start;
	int frame = ent->client->ps.gunframe;

	//ent->client->weapon_sound = gi.soundindex("weapons/hyprbl1a.wav");

	if (!(ent->client->buttons & BUTTON_ATTACK)&&!(!ent->client->hypr_set&&ent->client->ps.gunframe<12))
	{
		ent->client->ps.gunframe++;
	}
	else
	{
		if (! ent->client->pers.inventory[ent->client->ammo_index] )
		{
			if (level.time >= ent->pain_debounce_time)
			{
				gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
				ent->pain_debounce_time = level.time + 1;
			}
//			NoAmmoWeaponChange (ent);
		}
		else if ((ent->waterlevel>2)) //can't shoot if in water
		{
				gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
				ent->pain_debounce_time = level.time + 1;
		}
		else
		{
			rotation = (ent->client->ps.gunframe - 5) * 2*M_PI/6;
			g_offset[0] = -4 * sin(rotation);
			g_offset[1] = 0;
			g_offset[2] = 4 * cos(rotation);

			if ((ent->client->ps.gunframe == 6) || (ent->client->ps.gunframe == 9))
				effect = EF_HYPERBLASTER;
			else
				effect = 0;

				damage = 30 + (int)(random() * 10.0);


								/*	waterlevel	 
                                    0 - not in liquid
                                    1 - feet in liquid
                                    2 - on surface of liquid
                                    3 - surrounded by liquid  */
	
			AngleVectors (ent->client->v_angle, forward, right, NULL);
			//VectorSet(offset, 24, 8, ent->viewheight-8);
			VectorSet(offset, 24, 8, ent->viewheight-((ent->s.frame > 134)?8:30));
			VectorAdd (offset, g_offset, offset);
			P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

			VectorScale (forward, -2, ent->client->kick_origin);
			ent->client->kick_angles[0] = -1;


			//fire_blaster_hyper (ent, start, forward, damage, 500, effect, hyper);
			if (ent->client->hypr_set == 1)
			{

					damage=5;
					Plasma_Fire (ent, offset, damage);
					gi.sound(ent, CHAN_AUTO, gi.soundindex("brain/brnatck2.wav"), 0.8, ATTN_IDLE, 0);
				if (frame==4||frame==6||frame==8||frame==10||frame==12||frame==14||frame==16||frame==18||frame==20)
				{
					if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
						ent->client->pers.inventory[ent->client->ammo_index]--;
				}
			}
			else
				Blaster_Fire (ent, offset, damage, true, effect);

			//gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/grenlx1a.wav"), 1, ATTN_IDLE, 0);
			//fire_rail_2 (ent, start, forward, damage, 20);
			//gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/laser2.wav"), 1, ATTN_IDLE, 0);
			if (ent->client->hypr_set == 0)
				if (frame == 6 || frame == 9 || frame == 12 || frame == 15 || frame == 19)
				{
					if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
						ent->client->pers.inventory[ent->client->ammo_index]--;
				}

			ent->client->anim_priority = ANIM_ATTACK;
			if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
			{
				ent->s.frame = FRAME_crattak1 - 1;
				ent->client->anim_end = FRAME_crattak9;
			}
			else
			{
				ent->s.frame = FRAME_attack1 - 1;
				ent->client->anim_end = FRAME_attack8;
			}
		}

		ent->client->ps.gunframe++;
		if (ent->client->ps.gunframe == 12 && ent->client->pers.inventory[ent->client->ammo_index]
			&&(ent->client->buttons & BUTTON_ATTACK))
			ent->client->ps.gunframe = 6;
	}

	if (ent->client->ps.gunframe == 12)
	{
		//gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/hyprbd1a.wav"), 1, ATTN_NORM, 0);
		ent->client->weapon_sound = 0;
	}

}

void Weapon_HyperBlaster (edict_t *ent)
{
	static int	pause_frames[]	= {0};
	static int	fire_frames[]	= {6, 7, 8, 9, 10, 11, 0};

	ent->client->weaphold=8;

	Weapon_Generic (ent, 5, 20, 49, 53, pause_frames, fire_frames, Weapon_HyperBlaster_Fire);
}

/*
======================================================================

MACHINEGUN / CHAINGUN

======================================================================
*/

void Machinegun_Fire (edict_t *ent)
{
	int	i;
	vec3_t		start;
	vec3_t		forward, right;
	vec3_t		angles;
	int			damage = 40 + (int)(random() * 40.0);
	int			kick = 30;
	vec3_t		offset;
	vec3_t		offset2, start2;

	if (ent->client->mach_set==1)
	{
		ent->client->ps.gunframe++;
		ent->client->machinegun_shots=0;
	}
	else
	{
		if (!(ent->client->buttons & BUTTON_ATTACK)||(ent->client->ps.gunframe >= 6))
		{
			ent->client->machinegun_shots = 0;
			ent->client->ps.gunframe++;
			return;
		}
		if (ent->client->ps.gunframe == 5)
			ent->client->ps.gunframe = 4;
		else
			ent->client->ps.gunframe = 5;
	}

	if (ent->client->pers.inventory[ent->client->ammo_index] < 1)
	{
		ent->client->ps.gunframe++;
		if (level.time >= ent->pain_debounce_time&&ent->client->ps.gunframe==6)
		{
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time = level.time + 1;
		}
//		NoAmmoWeaponChange (ent);
		return;
	}

	if (is_quad)
	{
		damage *= 4;
		kick *= 4;
	}

	for (i=1 ; i<3 ; i++)
	{
		ent->client->kick_origin[i] = crandom() * 0.35 ;
		ent->client->kick_angles[i] = crandom() * 0.7 * ent->client->machinegun_shots;
	}
	ent->client->kick_origin[0] = crandom() * 0.35 ;
	ent->client->kick_angles[0] = ent->client->machinegun_shots * -1.5 ;

	// raise the gun as it is firing
	//if (!deathmatch->value)
	//{
		ent->client->machinegun_shots++;
		if (ent->client->machinegun_shots > 6)
			ent->client->machinegun_shots = 6;
	//}

	// get start / end positions
	VectorAdd (ent->client->v_angle, ent->client->kick_angles, angles);
	AngleVectors (angles, forward, right, NULL);
	VectorSet(offset, 0, 8, ent->viewheight-8);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	VectorSet(offset2, 20, 6,  ent->viewheight-5);
	P_ProjectSource (ent->client, ent->s.origin, offset2, forward, right, start2);
	
	fire_bullet (ent, start, forward, damage, kick, DEFAULT_BULLET_HSPREAD, DEFAULT_BULLET_VSPREAD, MOD_MACHINEGUN);

	if (ent->groundentity)
		AddKick (ent, forward, 1);

	if (sv_serversideonly->value)
		gi.sound(ent, CHAN_AUTO, gi.soundindex("soldier/solatck3.wav"), 0.75, ATTN_IDLE, 0);
	else
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/machinegun.wav"), 0.75, ATTN_IDLE, 0);

	PlayerNoise(ent, start, PNOISE_WEAPON);

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index]--;

	ent->client->anim_priority = ANIM_ATTACK;
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
	{
		ent->s.frame = FRAME_crattak1 - (int) (random()+0.25);
		ent->client->anim_end = FRAME_crattak9;
	}
	else
	{
		ent->s.frame = FRAME_attack1 - (int) (random()+0.25);
		ent->client->anim_end = FRAME_attack8;
	}
}

void Weapon_Machinegun (edict_t *ent)
{
	static int	pause_frames[]	= {23, 45, 0};
	static int	fire_frames[]	= {4, 5, 6, 0};

	ent->client->weaphold=4;

	Weapon_Generic (ent, 3, 8, 45, 49, pause_frames, fire_frames, Machinegun_Fire);
}

void Chaingun_Fire (edict_t *ent)
{
	int			i;
	vec3_t		start;
	vec3_t		forward, right, up;
	float		r, u;
	vec3_t		offset;
	vec3_t		offset2, start2;
	int			damage;
	int			kick = 100;

	damage = 75 + (int)(random() * 50.0);

	if (ent->client->ps.gunframe == 5)
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/chngnu1a.wav"), 1, ATTN_IDLE, 0);

	if ((ent->client->ps.gunframe == 14) && !(ent->client->buttons & BUTTON_ATTACK))
	{
		ent->client->ps.gunframe = 32;
		ent->client->weapon_sound = 0;
		return;
	}
	else if ((ent->client->ps.gunframe == 21) && (ent->client->buttons & BUTTON_ATTACK)
		&& ent->client->pers.inventory[ent->client->ammo_index])
	{
		ent->client->ps.gunframe = 15;
	}
	else
	{
		ent->client->ps.gunframe++;
	}

	if (ent->client->ps.gunframe == 22)
	{
		ent->client->weapon_sound = 0;
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/chngnd1a.wav"), 1, ATTN_IDLE, 0);
	}
	else
	{
//		ent->client->weapon_sound = gi.soundindex("weapons/chngnl1a.wav");
	}

	ent->client->anim_priority = ANIM_ATTACK;
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
	{
		ent->s.frame = FRAME_crattak1 - (ent->client->ps.gunframe & 1);
		ent->client->anim_end = FRAME_crattak9;
	}
	else
	{
		ent->s.frame = FRAME_attack1 - (ent->client->ps.gunframe & 1);
		ent->client->anim_end = FRAME_attack8;
	}

	if (!ent->client->pers.inventory[ent->client->ammo_index])
	{
		if (level.time >= ent->pain_debounce_time)
		{
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time = level.time + 1;
		}
//		NoAmmoWeaponChange (ent);
		return;
	}

	if (is_quad)
	{
		damage *= 4;
		kick *= 4;
	}

	for (i=0 ; i<3 ; i++)
	{
		ent->client->kick_origin[i] = crandom() * 0.35;
		ent->client->kick_angles[i] = crandom() * 0.7;
	}

	if (ent->client->chan_set==0)
	{

		// get start / end positions
		AngleVectors (ent->client->v_angle, forward, right, up);
		r = 7 + crandom()*4;
		u = crandom()*4;
		VectorSet(offset, 0, r, u + ent->viewheight-8);
		P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);
		VectorSet(offset2, 15, 6,  ent->viewheight-5);
		P_ProjectSource (ent->client, ent->s.origin, offset2, forward, right, start2);

		fire_bullet_3 (ent, start, forward, damage, kick, DEFAULT_BULLET_HSPREAD, DEFAULT_BULLET_VSPREAD, MOD_CHAINGUN);
		
		MuzzleEffect (ent, start2, forward, offset2);

		if (ent->groundentity)
			AddKick (ent, forward, 2);
		else if ((int)(random()*10)>7)
		
			AddKick (ent, forward, 3);

		gi.sound(ent, CHAN_AUTO, gi.soundindex("infantry/infatck1.wav"), 1.0, ATTN_IDLE, 0);
		gi.sound(ent, CHAN_AUTO, gi.soundindex("boss3/xfire.wav"), 0.5, ATTN_IDLE, 0);

		gi.WriteByte (svc_muzzleflash);
		gi.WriteShort (ent-g_edicts);
		gi.WriteByte (MZ_CHAINGUN1 | MZ_SILENCED);
		gi.multicast (ent->s.origin, MULTICAST_PVS);

		if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
			ent->client->pers.inventory[ent->client->ammo_index] -= 1;
	}
	else if ((ent->client->chan_set==1)&&!(ent->client->ps.gunframe%2))
	{
		AngleVectors (ent->client->v_angle, forward, right, up);
		r = 7 + crandom()*4;
		u = crandom()*4;
		VectorSet(offset, 0, r, u + ent->viewheight-8);
		P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);
		VectorSet(offset2, 15, 6,  ent->viewheight-5);
		P_ProjectSource (ent->client, ent->s.origin, offset2, forward, right, start2);

		fire_shotgun_2 (ent, start, forward, damage/5, kick, DEFAULT_BULLET_VSPREAD*ROTSHOTMULT , DEFAULT_BULLET_VSPREAD*ROTSHOTMULT , 5, MOD_CHAINGUN2);
		fire_shotgun_3 (ent, start, forward, damage/5, kick, DEFAULT_BULLET_VSPREAD*ROTSHOTMULT , DEFAULT_BULLET_VSPREAD*ROTSHOTMULT , 5, MOD_CHAINGUN2);
		
		MuzzleEffect (ent, start2, forward, offset2);

		if (ent->groundentity)
			AddKick (ent, forward, 2);
		else if ((int)(random()*10)>7)
			AddKick (ent, forward, 3);

		gi.WriteByte (svc_muzzleflash);
		gi.WriteShort (ent-g_edicts);
		gi.WriteByte (MZ_CHAINGUN1);
		gi.multicast (ent->s.origin, MULTICAST_PVS);
	
		if (sv_serversideonly->value)
		{
			gi.sound(ent, CHAN_AUTO, gi.soundindex("soldier/solatck1.wav"), 1, ATTN_IDLE, 0);
			gi.sound(ent, CHAN_AUTO, gi.soundindex("medic/medatck1.wav"), 1, ATTN_IDLE, 0);
			gi.sound(ent, CHAN_AUTO, gi.soundindex("boss3/xfire.wav"), 1, ATTN_IDLE, 0);
		}
		else
			gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/chainshot.wav"), 0.75, ATTN_IDLE, 0);

		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/shotgf1b.wav"), 1, ATTN_IDLE, 0);

		if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
			ent->client->pers.inventory[ent->client->ammo_index] -= 2;	
	}

	if (ent->client->pers.inventory[ent->client->ammo_index]<0)
		ent->client->pers.inventory[ent->client->ammo_index]=0;

}


void Weapon_Chaingun (edict_t *ent)
{
	static int	pause_frames[]	= {38, 43, 51, 61, 0};
	static int	fire_frames[]	= {5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 0};

	ent->client->weaphold=5;

	Weapon_Generic (ent, 4, 31, 61, 64, pause_frames, fire_frames, Chaingun_Fire);
}


/*
======================================================================

SHOTGUN / SUPERSHOTGUN

======================================================================
*/
void weapon_shotgun_fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	vec3_t		offset;
	vec3_t		offset2, start2;
	int			damage = 10;
	int			kick = 10;

	if (ent->client->pers.inventory[ent->client->ammo_index] < 1)
	{
//		NoAmmoWeaponChange (ent);
		return;
	}

	if (ent->waterlevel>2 && !sv_waterlevel->value) //can't shoot if in water
	{
		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
		ent->pain_debounce_time = level.time + 1;
		ent->client->ps.gunframe=19;
		return;
	}

	AngleVectors (ent->client->v_angle, forward, right, NULL);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -2;

	VectorSet(offset2, 15, 5,  ent->viewheight-3);
	P_ProjectSource (ent->client, ent->s.origin, offset2, forward, right, start2);
	VectorSet(offset, 0, 8,  ent->viewheight-8);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	if (is_quad)
	{
		damage *= 4;
		kick *= 4;
	}


	if (ent->client->shot_set)
	{
		damage*=20;
		fire_bullet_3 (ent, start, forward, damage, kick, DEFAULT_BULLET_HSPREAD, DEFAULT_BULLET_VSPREAD, MOD_SHOTGUN2);
	}
	else
	{
		fire_shotgun_2 (ent, start, forward, damage, kick, DEFAULT_BULLET_VSPREAD , DEFAULT_BULLET_VSPREAD , 5, MOD_SHOTGUN);
		fire_shotgun_3 (ent, start, forward, damage, kick, DEFAULT_BULLET_VSPREAD , DEFAULT_BULLET_VSPREAD , 5, MOD_SHOTGUN);
	}

	if (ent->groundentity)
		AddKick (ent, forward, 2);

	MuzzleEffect (ent, start2, forward, offset2);

	ent->client->ps.gunframe++;
	gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/shotgf1b.wav"), 0.75, ATTN_IDLE, 0);

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index]--;
}

void Weapon_Shotgun (edict_t *ent)
{
	static int	pause_frames[]	= {22, 28, 34, 0};
	static int	fire_frames[]	= {8, 0};

	ent->client->weaphold=2;


	if ((ent->client->weaponstate == WEAPON_FIRING || ent->client->weaponstate == WEAPON_READY)
		&& (ent->client->buttons & BUTTON_ATTACK)
		&& ent->client->ps.gunframe!=8
		&& ent->client->ps.gunframe!=9
		&& ent->client->ps.gunframe!=10
		&& ent->client->ps.gunframe!=13
		&& ent->client->ps.gunframe!=14
		&& ent->client->ps.gunframe!=15
		&& ent->client->ps.gunframe!=16
		&& ent->client->ps.gunframe!=17
		&& ent->client->ps.gunframe!=18)
	{
		ent->client->ps.gunframe = 7;
		ent->client->weaponstate = WEAPON_READY;
		ent->client->latched_buttons |= BUTTON_ATTACK;
	}
	else
	{
		ent->client->buttons &= ~BUTTON_ATTACK;
		ent->client->latched_buttons &= ~BUTTON_ATTACK;
	}

	if (ent->client->ps.gunframe==12 && !(ent->client->buttons & BUTTON_ATTACK)
		&& ent->client->pers.inventory[ent->client->ammo_index])
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/shotgr1b.wav"), 1, ATTN_IDLE, 0);

	Weapon_Generic (ent, 7, 18, 36, 39, pause_frames, fire_frames, weapon_shotgun_fire);
}


void weapon_supershotgun_fire (edict_t *ent)
{
	vec3_t		start, start1 ;//, end;
	vec3_t		forward, right;
	vec3_t		offset, offset1;
	vec3_t		offset2, start2;
	vec3_t		offset3, start3;
	vec3_t		v;
	int			damage, i;
	int			kick = 5;
	int shotgun_shots;
//	float u;

	if (ent->client->ps.gunframe==12)
	{
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/shotgr1b.wav"), 1, ATTN_IDLE, 0);
		ent->client->ps.gunframe++;
		return;
	}

	if (ent->client->ps.gunframe==8&&!ent->client->shot_set)
	{
		ent->client->ps.gunframe++;
		return;
	}

	shotgun_shots	= 20; //the number of bullets per shot
	damage			= 15; //the amount of damage per bullet

	AngleVectors (ent->client->v_angle, forward, right, NULL);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -2;

	VectorSet(offset, 0, 8,  ent->viewheight-8);
	VectorSet(offset1, 0, 4,  ent->viewheight-8);
	VectorSet(offset2, 15, 8,  ent->viewheight-3);
	VectorSet(offset3, 15, 4,  ent->viewheight-3);
	
	P_ProjectSource (ent->client, ent->s.origin, offset3, forward, right, start3);
	P_ProjectSource (ent->client, ent->s.origin, offset2, forward, right, start2);
	P_ProjectSource (ent->client, ent->s.origin, offset1, forward, right, start1);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	v[PITCH] = ent->client->v_angle[PITCH];
	v[YAW]   = ent->client->v_angle[YAW] ;
	v[ROLL]  = ent->client->v_angle[ROLL];
	AngleVectors (v, forward, NULL, NULL);


	if (ent->client->shot_set)
	{
		damage*=10;
		if (ent->client->ps.gunframe==7)
		{
			MuzzleEffect (ent, start2, forward, offset2);
			fire_bullet_3 (ent, start,  forward, damage, kick, DEFAULT_BULLET_HSPREAD*2, DEFAULT_BULLET_VSPREAD*(0.25), MOD_SSHOTGUN2);
		}
		else
		{
			MuzzleEffect (ent, start3, forward, offset3);
			fire_bullet_3 (ent, start1, forward, damage, kick, DEFAULT_BULLET_HSPREAD*2, DEFAULT_BULLET_VSPREAD*(0.25), MOD_SSHOTGUN2);
		}
	}
	else
	{
		fire_shotgun_2 (ent, start, forward, damage, kick, DEFAULT_BULLET_HSPREAD * 2, DEFAULT_BULLET_VSPREAD * 1.5, shotgun_shots/2, MOD_SSHOTGUN);
		fire_shotgun_3 (ent, start, forward, damage, kick, DEFAULT_BULLET_HSPREAD * 2, DEFAULT_BULLET_VSPREAD * 1.5, shotgun_shots/2, MOD_SSHOTGUN);

		MuzzleEffect (ent, start2, forward, offset2);
		MuzzleEffect (ent, start3, forward, offset3);
	}

	AddKick (ent, forward, 4);

	// send muzzle flash
	if (false)
	{
		gi.WriteByte (svc_muzzleflash);
		gi.WriteShort (ent-g_edicts);
		gi.WriteByte (MZ_SSHOTGUN | is_silenced);
		gi.multicast (ent->s.origin, MULTICAST_PVS);
	}

	if (sv_serversideonly->value)
	{
		gi.sound(ent, CHAN_AUTO, gi.soundindex("boss3/xfire.wav"), 0.75, ATTN_IDLE, 0);
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/shotgf1b.wav"), 0.75, ATTN_NORM, 0);
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/shotgf1b.wav"), 0.75, ATTN_NORM, 0);
	}
	else
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/shottyblast.wav"), 0.75, ATTN_NORM, 0);

	ent->client->ps.gunframe++;
	PlayerNoise(ent, start, PNOISE_WEAPON);

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index] -= (ent->client->shot_set)? 1: 2;
}

void Weapon_SuperShotgun (edict_t *ent)
{
	static int	pause_frames[]	= {29, 42, 57, 0};
	static int	fire_frames[]	= {7, 8, 12, 0};
	
	ent->client->weaphold=3;

	Weapon_Generic (ent, 6, 17, 57, 61, pause_frames, fire_frames, weapon_supershotgun_fire);
}



/*
======================================================================

RAILGUN

======================================================================
*/

void weapon_railgun_fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	vec3_t		offset;
	vec3_t		offset2, start2;
	int			damage, kick, i;

	damage = 300 + (int)(random() * 50.0);
	kick = 200;

	if (is_quad)
	{
		damage *= 4;
		kick *= 4;
	}

	AngleVectors (ent->client->v_angle, forward, right, NULL);

	VectorScale (forward, -3, ent->client->kick_origin);
	ent->client->kick_angles[0] = -3;

	VectorSet(offset, 0, 7,  ent->viewheight-8);
	VectorSet(offset2, 30, 6,  ent->viewheight-2);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);
	P_ProjectSource (ent->client, ent->s.origin, offset2, forward, right, start2);


	if (!ent->client->rail_set)
	{
		if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
			if (ent->client->pers.inventory[ITEM_INDEX(FindItem("slugs"))]<=0)
			{
				gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
				//ent->client->weaponstate = WEAPON_READY;
				ent->client->ps.gunframe++;
				return;
			}
			else
				ent->client->pers.inventory[ITEM_INDEX(FindItem("slugs"))]--;
		

		//if (deathmatch->value&&!sv_realbullets->value&&false)
		//	fire_bullet_2 (ent, start, forward, damage, kick, MOD_RAILGUN);
		//else
		fire_bullet_slow (ent, start, forward, sv_maxvelocity->value, 222, damage, MOD_RAILGUN, 0);


		if (ent->groundentity)
			AddKick (ent, forward, 1);
		else
			AddKick (ent, forward, 3);

		ent->client->ps.gunframe++;
	}
	else
	{
		if ((ent->client->buttons & BUTTON_ATTACK) && 
			(ent->client->pers.inventory[ITEM_INDEX(FindItem("cells"))] || ((int)dmflags->value & DF_INFINITE_AMMO)))
		{
			if (!ent->client->tazer_on||!ent->client->tazer_on->owner)
					ent->client->tazer=0;
			if (ent->client->tazer==0)
			{
				fire_tazer (ent, start, forward, 750);
				ent->client->tazer = 1;

				gi.sound(ent, CHAN_AUTO, gi.soundindex("hover/hovatck1.wav"), 0.5, ATTN_IDLE, 0);
				gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/shotgf1b.wav"), 0.75, ATTN_IDLE, 0);
				gi.sound(ent, CHAN_AUTO, gi.soundindex("world/airhiss2.wav"), 0.5, ATTN_IDLE, 0);
			}
		}
		else
		{
			ent->client->tazer = 10;
			ent->client->ps.gunframe++;
		}
	}
}


void Weapon_Railgun (edict_t *ent)
{
	static int	pause_frames[]	= {56, 0};
	static int	fire_frames[]	= {4, 0};

	ent->client->weaphold=(!ent->client->rail_set)?9: 0;

	Weapon_Generic (ent, 3, 18, 56, 61, pause_frames, fire_frames, weapon_railgun_fire);
}


/*
======================================================================

BFG10K

======================================================================
*/


void weapon_bfg_fire (edict_t *ent)
{
//	vec3_t		v;
	vec3_t	offset, start;
	vec3_t	forward, right;
	vec3_t   g_offset;
	int		damage;
	float	damage_radius;
	int		radius_damage;
	float	speed;
	int		cont=1;

	damage = 100 + (int)(random() * 20.0);
	radius_damage = 1000 + (int)(random() * 1000.0);
	damage_radius = 350;		//damage_radius = 80;
	/*if (is_quad)
	{
		damage *= 4;
		radius_damage *= 4;
	}*/

	AngleVectors (ent->client->v_angle, forward, right, NULL);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -1;

	VectorSet(offset, 8, 8, ent->viewheight-8);

	if (!ent->bfg_laser_type)
		ent->bfg_laser_type=BFG_LASER_GREEN;

	if (ent->client->bfg_set==2)
	{
		if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
			if (ent->client->pers.inventory[ITEM_INDEX(FindItem("cells"))]<BFG_LASER_AMMO)
			{
				gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
				ent->client->weaponstate = WEAPON_READY;
				ent->client->ps.gunframe = 33;
				cont=0;
			}
			else
				ent->client->pers.inventory[ITEM_INDEX(FindItem("cells"))]-=BFG_LASER_AMMO;
		
		if (cont)
		{
			ent->client->ps.gunframe+=BFG_FRAME_LEAP;

			ent->client->bfg_firing=10;
			gi.sound (ent, CHAN_WEAPON, gi.soundindex("weapons/laser2.wav"), 1, ATTN_NORM, 0);
		}
	}
	else
	{
		if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
			if (ent->client->pers.inventory[ITEM_INDEX(FindItem("rockets"))]<BFG_ROCKET_AMMO)
			{
				gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
				ent->client->weaponstate = WEAPON_READY;
				ent->client->ps.gunframe = 33;
				cont=0;
			}
			else
				ent->client->pers.inventory[ITEM_INDEX(FindItem("rockets"))]-=BFG_ROCKET_AMMO;
		if (cont)
		{
			ent->client->ps.gunframe+=BFG_FRAME_LEAP;

			g_offset[0] = 0;
			g_offset[1] = 10;
			g_offset[2] = 0;
			
			VectorSet(offset, 8, 8, ent->viewheight-8);
			VectorAdd (offset, g_offset, offset);
			P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

			VectorScale (forward, -2, ent->client->kick_origin);
			ent->client->kick_angles[0] = -1;

			damage = 2500;		// + (int)(random() * 150.0);
			speed = 1500;		//speed = 1000 + (int)(random() * 1000.0);
			
			VectorNormalize(forward);
			fire_rocket_bfg (ent, start, forward, damage, speed, damage_radius, radius_damage);

			// send muzzle flash
			gi.WriteByte (svc_muzzleflash);
			gi.WriteShort (ent-g_edicts);
			gi.WriteByte (MZ_ROCKET | is_silenced);
			gi.multicast (ent->s.origin, MULTICAST_PVS);

			AddKick (ent, forward, 8);

			PlayerNoise(ent, start, PNOISE_WEAPON);
		}

	}


	ent->client->ps.gunframe++;
}

void Weapon_BFG (edict_t *ent)
{
	static int	pause_frames[]	= {39, 45, 50, 55, 0};
	static int	fire_frames[]	= {9, 0};

	ent->client->weaphold=10;

	//Weapon_Generic (ent, 8, 32, 55, 58, pause_frames, fire_frames, weapon_bfg_fire);
	Weapon_Generic (ent, 8, 32, 55, 58, pause_frames, fire_frames, weapon_bfg_fire);
}


//======================================================================
