
#include "g_local.h"


void	Svcmd_Test_f (void)
{
	gi.cprintf (NULL, PRINT_HIGH, "Svcmd_Test_f()\n");
}

/*
==============================================================================

PACKET FILTERING
 

You can add or remove addresses from the filter list with:

addip <ip>
removeip <ip>

The ip address is specified in dot format, and any unspecified digits will match any value, so you can specify an entire class C network with "addip 192.246.40".

Removeip will only remove an address specified exactly the same way.  You cannot addip a subnet, then removeip a single host.

listip
Prints the current list of filters.

writeip
Dumps "addip <ip>" commands to listip.cfg so it can be execed at a later date.  The filter lists are not saved and restored by default, because I beleive it would cause too much confusion.

filterban <0 or 1>

If 1 (the default), then ip addresses matching the current list will be prohibited from entering the game.  This is the default setting.

If 0, then only addresses matching the list will be allowed.  This lets you easily set up a private game, or a game that only allows players from your local network.


==============================================================================
*/

typedef struct
{
	unsigned	mask;
	unsigned	compare;
} ipfilter_t;

#define	MAX_IPFILTERS	1024

ipfilter_t	ipfilters[MAX_IPFILTERS];
int			numipfilters;

/*
=================
StringToFilter
=================
*/
static qboolean StringToFilter (char *s, ipfilter_t *f)
{
	char	num[128];
	int		i, j;
	byte	b[4];
	byte	m[4];
	
	for (i=0 ; i<4 ; i++)
	{
		b[i] = 0;
		m[i] = 0;
	}
	
	for (i=0 ; i<4 ; i++)
	{
		if (*s < '0' || *s > '9')
		{
			gi.cprintf(NULL, PRINT_HIGH, "Bad filter address: %s\n", s);
			return false;
		}
		
		j = 0;
		while (*s >= '0' && *s <= '9')
		{
			num[j++] = *s++;
		}
		num[j] = 0;
		b[i] = atoi(num);
		if (b[i] != 0)
			m[i] = 255;

		if (!*s)
			break;
		s++;
	}
	
	f->mask = *(unsigned *)m;
	f->compare = *(unsigned *)b;
	
	return true;
}

/*
=================
SV_FilterPacket
=================
*/
qboolean SV_FilterPacket (char *from)
{
	int		i;
	unsigned	in;
	byte m[4];
	char *p;

	i = 0;
	p = from;
	while (*p && i < 4) {
		m[i] = 0;
		while (*p >= '0' && *p <= '9') {
			m[i] = m[i]*10 + (*p - '0');
			p++;
		}
		if (!*p || *p == ':')
			break;
		i++, p++;
	}
	
	in = *(unsigned *)m;

	for (i=0 ; i<numipfilters ; i++)
		if ( (in & ipfilters[i].mask) == ipfilters[i].compare)
			return (int)filterban->value;

	return (int)!filterban->value;
}

/*
=================
SV_Cheats_f
=================
*/
void SVCmd_Cheats_f (void)
{
	char *msg;

	msg = "sv cheats -- Bad Arguments\n";

	if ((!sv_cheats->value) || (Q_strcasecmp(gi.argv(2), "on")==0)||
		(Q_strcasecmp(gi.argv(2), "1")==0) )
	{
		msg = "Cheats on server are now ON\n";
		sv_cheats->value = 1;
	}
	else if ((sv_cheats->value)||(Q_strcasecmp(gi.argv(2), "off")==0)||
		(Q_strcasecmp(gi.argv(2), "0")==0) )
	{
		msg = "Cheats on server are now OFF\n";
		sv_cheats->value = 0;
	}

	gi.cprintf (NULL, PRINT_HIGH, msg);

}

/*
=================
SV_Teams_f
=================
*/
void SVCmd_Teams_f (void)
{
	char *msg;

	msg = "sv cheats -- Bad Arguments\n";

	if (coop->value)
	{
		if (sv_teams->value)
		{
			sv_teams->value = 0;
			msg = "Friendly Fire ON\n";
		}
		else
		{
			sv_teams->value = 1;
			msg = "Friendly Fire OFF\n";
		}

	}
	else if (!deathmatch->value)
		return;
	else
	{
		if (!Q_strcasecmp(gi.argv(2), "lock"))
		{
			sv_teams->value = 1;
			sv_teams_locked->value=1;
			msg = "Color Teams are now LOCKED\n";
		}
		else if (!Q_strcasecmp(gi.argv(2), "unlock"))
		{
			sv_teams->value = 1;
			sv_teams_locked->value=0;
			msg = "Color Teams are now UNLOCKED\n";
		}
		else if ((!sv_teams->value) || !(Q_strcasecmp(gi.argv(2), "on"))||
			!(Q_strcasecmp(gi.argv(2), "1")) )
		{
			msg = "Color Teams now ON\n";
			sv_teams->value = 1;
		}
		else if ((sv_teams->value)|| !(Q_strcasecmp(gi.argv(2), "off"))||
			!(Q_strcasecmp(gi.argv(2), "0")) )
		{
			msg = "Color Teams now OFF\n";
			sv_teams->value = 0;
		}
	}

	gi.cprintf (NULL, PRINT_HIGH, msg);

}

/*
=================
SV_AddIP_f
=================
*/
void SVCmd_AddIP_f (void)
{
	int		i;
	
	if (gi.argc() < 3) {
		gi.cprintf(NULL, PRINT_HIGH, "Usage:  addip <ip-mask>\n");
		return;
	}

	for (i=0 ; i<numipfilters ; i++)
		if (ipfilters[i].compare == 0xffffffff)
			break;		// free spot
	if (i == numipfilters)
	{
		if (numipfilters == MAX_IPFILTERS)
		{
			gi.cprintf (NULL, PRINT_HIGH, "IP filter list is full\n");
			return;
		}
		numipfilters++;
	}
	
	if (!StringToFilter (gi.argv(2), &ipfilters[i]))
		ipfilters[i].compare = 0xffffffff;
}

/*
=================
SV_RemoveIP_f
=================
*/
void SVCmd_RemoveIP_f (void)
{
	ipfilter_t	f;
	int			i, j;

	if (gi.argc() < 3) {
		gi.cprintf(NULL, PRINT_HIGH, "Usage:  sv removeip <ip-mask>\n");
		return;
	}

	if (!StringToFilter (gi.argv(2), &f))
		return;

	for (i=0 ; i<numipfilters ; i++)
		if (ipfilters[i].mask == f.mask
		&& ipfilters[i].compare == f.compare)
		{
			for (j=i+1 ; j<numipfilters ; j++)
				ipfilters[j-1] = ipfilters[j];
			numipfilters--;
			gi.cprintf (NULL, PRINT_HIGH, "Removed.\n");
			return;
		}
	gi.cprintf (NULL, PRINT_HIGH, "Didn't find %s.\n", gi.argv(2));
}

/*
===========
MONSTER SPAWNING

Add monsters in DM
============
*/
/*
================
SelectRandomDeathmatchSpawnPoint

go to a random point, but NOT the two points closest
to other players
================
*/
edict_t *SelectRandomDeathmatchSpawnPointMonster (void)
{
	edict_t	*spot, *spot1, *spot2;
	int		count = 0;
	int		selection;
	float	range, range1, range2;

	spot = NULL;
	range1 = range2 = 99999;
	spot1 = spot2 = NULL;

	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL)
	{
		count++;
		range = PlayersRangeFromSpot(spot);
		if (range < range1)
		{
			range1 = range;
			spot1 = spot;
		}
		else if (range < range2)
		{
			range2 = range;
			spot2 = spot;
		}
	}

	if (!count)
		return NULL;

	if (count <= 2)
	{
		spot1 = spot2 = NULL;
	}
	else
		count -= 2;

	selection = rand() % count;

	spot = NULL;
	do
	{
		spot = G_Find (spot, FOFS(classname), "info_player_deathmatch");
		if (spot == spot1 || spot == spot2)
			selection++;
	} while(selection--);

	return spot;
}

void	MonsterSpawn (edict_t *ent, vec3_t origin, vec3_t angles)
{
	edict_t	*spot = NULL;

	if (VectorLength(nextmonsterspawn))
	{
		VectorCopy (nextmonsterspawn, origin);
		VectorCopy (nextmonsterspawnangles, angles);
		VectorClear (nextmonsterspawn);
		VectorClear (nextmonsterspawnangles);
		KillBox(ent);
		return;
	}

	spot = SelectRandomDeathmatchSpawnPointMonster ();

	// find a single player start spot
	if (!spot)
	{
		while ((spot = G_Find (spot, FOFS(classname), "info_player_start")) != NULL)
		{
			if (!game.spawnpoint[0] && !spot->targetname)
				break;

			if (!game.spawnpoint[0] || !spot->targetname)
				continue;

			if (Q_stricmp(game.spawnpoint, spot->targetname) == 0)
				break;
		}

		if (!spot)
		{
			if (!game.spawnpoint[0])
			{	// there wasn't a spawnpoint without a target, so use any
				spot = G_Find (spot, FOFS(classname), "info_player_start");
			}
			if (!spot)
				gi.error ("Couldn't find spawn point %s\n", game.spawnpoint);
		}
	}

	VectorCopy (spot->s.origin, origin);
	origin[2] += 9;
	VectorCopy (spot->s.angles, angles);

	//add standard spawn shizt
	KillBox(ent);

	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (spot-g_edicts);
	gi.WriteByte (MZ_LOGIN);
	gi.multicast (spot->s.origin, MULTICAST_PVS);

}

void SVCmd_Monster_f (void)
{
	edict_t	*ent;
	char	*monster;
	int j;

	monster = gi.argv(2);

	if (!(deathmatch->value))
	{
		gi.cprintf (NULL, PRINT_HIGH, "Cannot spawn monsters in Coop or SP\n");
		return;
	}
	deathmatch->value=0;

//	gi.cprintf (NULL, PRINT_HIGH, "\"%s\"\n", monster);

	//START MONSTER SPAWN CODE...
	if (Q_strcasecmp(monster, "berserk")==0)
	{
		ent = G_Spawn();
		ent->classname="monster_berserk";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_monster_berserk(ent);
		monster="Berserk";
		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if (Q_strcasecmp(monster, "gunner")==0)
	{
		ent = G_Spawn();
		ent->classname="monster_gunner";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_monster_gunner(ent);
		monster="Gunner";
		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if (Q_strcasecmp(monster, "infantry")==0)
	{
		ent = G_Spawn();
		ent->classname="monster_infantry";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_monster_infantry(ent);
		monster="Infantry";
		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if (Q_strcasecmp(monster, "soldier1")==0)
	{
		ent = G_Spawn();
		ent->classname="monster_soldier_light";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_monster_soldier_light(ent);
		monster="Blaster Soldier";
		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if (Q_strcasecmp(monster, "soldier2")==0)
	{
		ent = G_Spawn();
		ent->classname="monster_soldier";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_monster_soldier(ent);
		monster="Shotgun Soldier";
		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if (Q_strcasecmp(monster, "soldier3")==0)
	{
		ent = G_Spawn();
		ent->classname="monster_soldier_ss";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_monster_soldier_ss(ent);
		monster="SMG Soldier";
		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if (Q_strcasecmp(monster, "chick")==0)
	{
		ent = G_Spawn();
		ent->classname="monster_chick";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_monster_chick(ent);
		monster="Chick";
		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if (Q_strcasecmp(monster, "mutant")==0)
	{
		ent = G_Spawn();
		ent->classname="monster_mutant";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_monster_mutant(ent);
		monster="Mutant";
		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if (Q_strcasecmp(monster, "floater")==0)
	{
		ent = G_Spawn();
		ent->classname="monster_floater";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_monster_floater(ent);
		monster="Floater";
		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if (Q_strcasecmp(monster, "hover")==0)
	{
		ent = G_Spawn();
		ent->classname="monster_hover";
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_monster_hover(ent);
		monster="Hover";
		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else if ((Q_strcasecmp(monster, "rand")==0)||
			 (Q_strcasecmp(monster, "random")==0)||
			 (Q_strcasecmp(monster, "")==0))
	{
		ent = G_Spawn();
		MonsterSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		if (random()>.8)
		{
			ent->classname="monster_hover";
			monster="Hover";
			SP_monster_hover(ent);
		}
		else if (random()>.85)
		{
			ent->classname="monster_floater";
			monster="Floater";
			SP_monster_floater(ent);
		}
		else if (random()>.80)
		{
			ent->classname="monster_mutant";
			monster="Mutant";
			SP_monster_mutant(ent);
		}
		else if (random()>.75)
		{
			ent->classname="monster_chick";
			monster="Chick";
			SP_monster_chick(ent);
		}
		else if (random()>.70)
		{
			ent->classname="monster_soldier_ss";
			monster="SMG Soldier";
			SP_monster_soldier_ss(ent);
		}
		else if (random()>.65)
		{
			ent->classname="monster_soldier";
			monster="Shotgun Soldier";
			SP_monster_soldier(ent);
		}
		else if (random()>.60)
		{
			ent->classname="monster_soldier_light";
			monster="Blaster Soldier";
			SP_monster_soldier_light(ent);
		}
		else if (random()>.55)
		{
			ent->classname="monster_infantry";
			monster="Infantry";
			SP_monster_infantry(ent);
		}
		else if (random()>.50)
		{
			ent->classname="monster_gunner";
			monster="Gunner";
			SP_monster_gunner(ent);
		}
		else
		{
			ent->classname="monster_berserk";
			monster="Berserk";
			SP_monster_berserk(ent);
		}
		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", monster);
	}
	else
	{
		gi.cprintf (NULL, PRINT_HIGH, "Invalid Monster\n");
		deathmatch->value=1;
		return;
	}
	//END MONSTER SPAWN CODE
	//clear spawn point

	ent->target_ent = ent;
	ent->MonsterFind = ent;
	ent->enemy = ent;
	ent->goalentity = ent;
	ent->movetarget = ent;

	deathmatch->value=1;
}

/*
=================
SV_ListIP_f
=================
*/
void SVCmd_ListIP_f (void)
{
	int		i;
	byte	b[4];

	gi.cprintf (NULL, PRINT_HIGH, "Filter list:\n");
	for (i=0 ; i<numipfilters ; i++)
	{
		*(unsigned *)b = ipfilters[i].compare;
		gi.cprintf (NULL, PRINT_HIGH, "%3i.%3i.%3i.%3i\n", b[0], b[1], b[2], b[3]);
	}
}

/*
=================
SV_WriteIP_f
=================
*/
void SVCmd_WriteIP_f (void)
{
	FILE	*f;
	char	name[MAX_OSPATH];
	byte	b[4];
	int		i;
	cvar_t	*game;

	game = gi.cvar("game", "", 0);

	if (!*game->string)
		sprintf (name, "%s/listip.cfg", GAMEVERSION);
	else
		sprintf (name, "%s/listip.cfg", game->string);

	gi.cprintf (NULL, PRINT_HIGH, "Writing %s.\n", name);

	f = fopen (name, "wb");
	if (!f)
	{
		gi.cprintf (NULL, PRINT_HIGH, "Couldn't open %s\n", name);
		return;
	}
	
	fprintf(f, "set filterban %d\n", (int)filterban->value);

	for (i=0 ; i<numipfilters ; i++)
	{
		*(unsigned *)b = ipfilters[i].compare;
		fprintf (f, "sv addip %i.%i.%i.%i\n", b[0], b[1], b[2], b[3]);
	}
	
	fclose (f);
}


/*
=================
SV_ListIP_f
=================
*/
void SVCmd_Nextmap_f (void)
{
	edict_t	*ent = G_Find (NULL, FOFS(classname), "target_changelevel");
	if (ent)
		BeginIntermission (ent);
}


/*
=================
ServerCommand

ServerCommand will be called when an "sv" command is issued.
The game can issue gi.argc() / gi.argv() commands to get the rest
of the parameters
=================
*/
void	ServerCommand (void)
{
	char	*cmd;

	cmd = gi.argv(1);
	if (Q_stricmp (cmd, "test") == 0)
		Svcmd_Test_f ();
	else if (Q_stricmp (cmd, "addip") == 0)
		SVCmd_AddIP_f ();
	else if (Q_stricmp (cmd, "removeip") == 0)
		SVCmd_RemoveIP_f ();
	else if (Q_stricmp (cmd, "listip") == 0)
		SVCmd_ListIP_f ();
	else if (Q_stricmp (cmd, "writeip") == 0)
		SVCmd_WriteIP_f ();
	else if (Q_stricmp (cmd, "cheats") == 0)
		SVCmd_Cheats_f ();
	else if (Q_stricmp (cmd, "teams") == 0)
		SVCmd_Teams_f ();
	else if (Q_stricmp (cmd, "spawn") == 0)
		SVCmd_Monster_f ();
	else if (Q_stricmp (cmd, "nextmap") == 0)
		SVCmd_Nextmap_f ();
	else
		gi.cprintf (NULL, PRINT_HIGH, "Unknown server command \"%s\"\n", cmd);
}

